/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.database.types.sql;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.arguments.DatabaseFilters;
import io.github.InsiderAnh.StellarProtect.arguments.RadiusArg;
import io.github.InsiderAnh.StellarProtect.arguments.TimeArg;
import io.github.InsiderAnh.StellarProtect.arguments.UsersArg;
import io.github.InsiderAnh.StellarProtect.cache.LoggerCache;
import io.github.InsiderAnh.StellarProtect.cache.PlayerCache;
import io.github.InsiderAnh.StellarProtect.cache.keys.LocationCache;
import io.github.InsiderAnh.StellarProtect.callback.CallbackLookup;
import io.github.InsiderAnh.StellarProtect.database.entries.LogEntry;
import io.github.InsiderAnh.StellarProtect.database.entries.items.ItemLogEntry;
import io.github.InsiderAnh.StellarProtect.database.entries.players.PlayerTransactionEntry;
import io.github.InsiderAnh.StellarProtect.database.repositories.LoggerRepository;
import io.github.InsiderAnh.StellarProtect.database.types.factory.LogEntryFactory;
import io.github.InsiderAnh.StellarProtect.enums.ActionType;
import io.github.InsiderAnh.StellarProtect.items.ItemTemplate;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.lang.Nullable;
import io.github.InsiderAnh.StellarProtect.utils.Debugger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;

public class LoggerRepositorySQL
implements LoggerRepository {
    private final StellarProtect stellarProtect = StellarProtect.getInstance();
    private final Connection connection;

    public LoggerRepositorySQL(Connection connection) {
        this.connection = connection;
    }

    @Override
    public void loadTemporaryLogs() {
        Debugger.debugLog("Loading logs from database...");
        AtomicInteger count = new AtomicInteger(0);
        long twelveHoursAgo = System.currentTimeMillis() - 43200000L;
        try {
            try (PreparedStatement stmt = this.connection.prepareStatement("SELECT ple.*, p.name, p.uuid FROM " + this.stellarProtect.getConfigManager().getTablesLogEntries() + " ple JOIN " + this.stellarProtect.getConfigManager().getTablesPlayers() + " p ON ple.player_id = p.id WHERE ple.created_at >= ? ORDER BY ple.created_at DESC LIMIT 10000");){
                stmt.setLong(1, twelveHoursAgo);
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    long playerId = rs.getLong("player_id");
                    String playerName = rs.getString("name");
                    PlayerCache.cacheName(playerId, playerName);
                    LogEntry entry = LogEntryFactory.fromDatabase(rs);
                    LoggerCache.loadLog(entry);
                    count.incrementAndGet();
                }
            }
            Debugger.debugLog("Loaded " + count.get() + " logs from database.");
        }
        catch (Exception e) {
            this.stellarProtect.getLogger().log(Level.SEVERE, "Failed to load temporary logs.", e);
        }
    }

    @Override
    public void clearOldLogs() {
        Debugger.debugLog("Clearing old logs...");
        this.stellarProtect.getExecutor().execute(() -> {
            int daysToKeep = this.stellarProtect.getConfigManager().getDaysToKeepLogs();
            long expirationTime = System.currentTimeMillis() - (long)daysToKeep * 24L * 60L * 60L * 1000L;
            try (PreparedStatement stmt = this.connection.prepareStatement("DELETE FROM " + this.stellarProtect.getConfigManager().getTablesLogEntries() + " WHERE created_at <= ?");){
                stmt.setLong(1, expirationTime);
                int deleted = stmt.executeUpdate();
                if (deleted > 0) {
                    Debugger.debugLog("Cleared " + deleted + " old logs from the database.");
                } else {
                    Debugger.debugLog("No old logs found to delete.");
                }
            }
            catch (SQLException e) {
                this.stellarProtect.getLogger().log(Level.SEVERE, "Failed to clear old logs.", e);
            }
        });
    }

    @Override
    public void purgeLogs(@NonNull DatabaseFilters databaseFilters) {
        if (databaseFilters == null) {
            throw new NullPointerException("databaseFilters is marked non-null but is null");
        }
        long start = System.currentTimeMillis();
        Debugger.debugSave("Purging logs...");
        ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1024)));
        executor.execute(() -> {
            try {
                String placeholders;
                TimeArg timeArg = databaseFilters.getTimeFilter();
                RadiusArg radiusArg = databaseFilters.getRadiusFilter();
                UsersArg usersArg = databaseFilters.getUserFilters();
                List<Integer> actionTypes = databaseFilters.getActionTypesFilter();
                ArrayList<String> whereConditions = new ArrayList<String>();
                ArrayList<Number> parameters = new ArrayList<Number>();
                if (timeArg != null) {
                    whereConditions.add("ple.created_at BETWEEN ? AND ?");
                    parameters.add(timeArg.getStart());
                    parameters.add(timeArg.getEnd());
                }
                if (radiusArg != null) {
                    whereConditions.add("ple.x BETWEEN ? AND ?");
                    whereConditions.add("ple.y BETWEEN ? AND ?");
                    whereConditions.add("ple.z BETWEEN ? AND ?");
                    parameters.add(radiusArg.getMinX());
                    parameters.add(radiusArg.getMaxX());
                    parameters.add(radiusArg.getMinY());
                    parameters.add(radiusArg.getMaxY());
                    parameters.add(radiusArg.getMinZ());
                    parameters.add(radiusArg.getMaxZ());
                }
                if (usersArg != null && usersArg.getUserIds() != null && !usersArg.getUserIds().isEmpty()) {
                    placeholders = usersArg.getUserIds().stream().map(id -> "?").collect(Collectors.joining(","));
                    whereConditions.add("ple.player_id IN (" + placeholders + ")");
                    parameters.addAll(usersArg.getUserIds());
                }
                if (actionTypes != null && !actionTypes.isEmpty()) {
                    placeholders = actionTypes.stream().map(type -> "?").collect(Collectors.joining(","));
                    whereConditions.add("ple.action_type IN (" + placeholders + ")");
                    parameters.addAll(actionTypes);
                }
                String whereClause = whereConditions.isEmpty() ? "" : "WHERE " + String.join((CharSequence)" AND ", whereConditions);
                String sql = "DELETE FROM " + this.stellarProtect.getConfigManager().getTablesLogEntries() + " ple " + whereClause;
                try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
                    for (int i = 0; i < parameters.size(); ++i) {
                        Object param = parameters.get(i);
                        if (param instanceof Long) {
                            stmt.setLong(i + 1, (Long)param);
                            continue;
                        }
                        if (param instanceof Double) {
                            stmt.setDouble(i + 1, (Double)param);
                            continue;
                        }
                        if (param instanceof Integer) {
                            stmt.setInt(i + 1, (Integer)param);
                            continue;
                        }
                        stmt.setObject(i + 1, param);
                    }
                    int deleted = stmt.executeUpdate();
                    if (deleted > 0) {
                        Debugger.debugSave("Purged " + deleted + " logs in " + (System.currentTimeMillis() - start) + "ms");
                    } else {
                        Debugger.debugSave("No logs found to delete.");
                    }
                }
            }
            catch (SQLException e) {
                this.stellarProtect.getLogger().log(Level.SEVERE, "Failed to purge logs.", e);
            }
        });
        executor.shutdown();
    }

    @Override
    public void save(List<LogEntry> logEntries) {
        long start = System.currentTimeMillis();
        Debugger.debugSave("Saving log entries...");
        this.stellarProtect.getExecutor().execute(() -> {
            try {
                this.connection.setAutoCommit(false);
                try (PreparedStatement playerStmt = this.connection.prepareStatement("INSERT INTO " + this.stellarProtect.getConfigManager().getTablesLogEntries() + " (player_id, world_id, x, y, z, action_type, extra_json, created_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");){
                    for (LogEntry playerLog : logEntries) {
                        String extraJson = playerLog.toSaveJson();
                        playerStmt.setLong(1, playerLog.getPlayerId());
                        playerStmt.setInt(2, playerLog.getWorldId());
                        playerStmt.setDouble(3, playerLog.getX());
                        playerStmt.setDouble(4, playerLog.getY());
                        playerStmt.setDouble(5, playerLog.getZ());
                        playerStmt.setInt(6, playerLog.getActionType());
                        playerStmt.setString(7, extraJson);
                        playerStmt.setLong(8, playerLog.getCreatedAt());
                        playerStmt.addBatch();
                    }
                    playerStmt.executeBatch();
                    this.connection.commit();
                }
                catch (Exception e) {
                    this.connection.rollback();
                    throw e;
                }
                finally {
                    this.connection.setAutoCommit(true);
                }
            }
            catch (Exception e) {
                this.stellarProtect.getLogger().log(Level.INFO, "Failed to save log entries.", e);
            }
            Debugger.debugSave("Saved " + logEntries.size() + " log entries in " + (System.currentTimeMillis() - start) + "ms");
        });
    }

    @Override
    public CompletableFuture<CallbackLookup<List<ItemLogEntry>, Long>> getChestTransactions(@NonNull Location location, int skip, int limit) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        return CompletableFuture.supplyAsync(() -> {
            List cachedLogs = LoggerCache.getChestTransactions(location, 0, Integer.MAX_VALUE).stream().filter(log -> System.currentTimeMillis() - log.getCreatedAt() <= TimeUnit.MINUTES.toMillis(15L)).sorted(Comparator.comparingLong(ItemLogEntry::getCreatedAt).reversed()).collect(Collectors.toList());
            List paginatedCachedLogs = cachedLogs.stream().skip(skip).limit(limit).collect(Collectors.toList());
            LinkedList result = new LinkedList(paginatedCachedLogs);
            int remaining = limit - paginatedCachedLogs.size();
            if (remaining > 0) {
                int effectiveSkipForDB = Math.max(0, skip - cachedLogs.size());
                int processedItemFromDB = 0;
                Set cachedItemKeys = cachedLogs.stream().map(ItemLogEntry::getItemStack).filter(Objects::nonNull).map(this::createItemKey).collect(Collectors.toSet());
                int addedFromDB = 0;
                int blockStart = 0;
                int blockSize = Math.max(10, remaining);
                long totalDBLogs = 0L;
                boolean hasMoreBlocks = true;
                while (addedFromDB < remaining && hasMoreBlocks) {
                    CallbackLookup<Set<LogEntry>, Long> dbLookup = this.queryLogsFromDB(location, blockStart, blockSize, ActionType.INVENTORY_TRANSACTION);
                    List dbLogs = dbLookup.getLogs().stream().filter(PlayerTransactionEntry.class::isInstance).sorted(Comparator.comparingLong(LogEntry::getCreatedAt).reversed()).collect(Collectors.toList());
                    if (dbLogs.isEmpty()) break;
                    int itemsAddedInThisBlock = 0;
                    block1: for (LogEntry log2 : dbLogs) {
                        String itemKey;
                        ItemStack item;
                        ItemTemplate itemTemplate;
                        PlayerTransactionEntry transaction = (PlayerTransactionEntry)log2;
                        if (addedFromDB >= remaining) {
                            totalDBLogs += (long)(transaction.getAdded().size() + transaction.getRemoved().size());
                            break;
                        }
                        totalDBLogs += (long)(transaction.getAdded().size() + transaction.getRemoved().size());
                        for (Map.Entry<Long, Integer> addedEntry : transaction.getAdded().entrySet()) {
                            if (++processedItemFromDB <= effectiveSkipForDB) continue;
                            if (addedFromDB >= remaining) break;
                            itemTemplate = this.stellarProtect.getItemsManager().getItemTemplate(addedEntry.getKey());
                            item = itemTemplate.getBukkitItem();
                            if (item == null || cachedItemKeys.contains(itemKey = this.createItemKey(item))) continue;
                            result.add(new ItemLogEntry(item, log2.getPlayerId(), addedEntry.getValue(), true, log2.getCreatedAt()));
                            ++addedFromDB;
                            ++itemsAddedInThisBlock;
                        }
                        for (Map.Entry<Long, Integer> removedEntry : transaction.getRemoved().entrySet()) {
                            if (++processedItemFromDB <= effectiveSkipForDB) continue;
                            if (addedFromDB >= remaining) continue block1;
                            itemTemplate = this.stellarProtect.getItemsManager().getItemTemplate(removedEntry.getKey());
                            item = itemTemplate.getBukkitItem();
                            if (item == null || cachedItemKeys.contains(itemKey = this.createItemKey(item))) continue;
                            result.add(new ItemLogEntry(item, log2.getPlayerId(), removedEntry.getValue(), false, log2.getCreatedAt()));
                            ++addedFromDB;
                            ++itemsAddedInThisBlock;
                        }
                    }
                    if (itemsAddedInThisBlock == 0 && addedFromDB < remaining) {
                        if ((long)((blockStart += blockSize) + blockSize) < totalDBLogs) continue;
                        hasMoreBlocks = false;
                        continue;
                    }
                    if (addedFromDB < remaining && dbLogs.size() == blockSize) {
                        if ((long)(blockStart += blockSize) < totalDBLogs) continue;
                        hasMoreBlocks = false;
                        continue;
                    }
                    hasMoreBlocks = false;
                }
                long estimatedTotalCount = (long)cachedLogs.size() + totalDBLogs;
                return new CallbackLookup(result, estimatedTotalCount);
            }
            return new CallbackLookup(result, Long.valueOf(cachedLogs.size()));
        }, (Executor)this.stellarProtect.getLookupExecutor());
    }

    private String createItemKey(ItemStack item) {
        return item.getType() + ":" + item.getDurability() + ":" + (item.hasItemMeta() ? item.getItemMeta().toString() : "null");
    }

    @Override
    public CompletableFuture<CallbackLookup<Map<LocationCache, Set<LogEntry>>, Long>> getLogs(@NonNull DatabaseFilters databaseFilters, int skip, int limit) {
        if (databaseFilters == null) {
            throw new NullPointerException("databaseFilters is marked non-null but is null");
        }
        return CompletableFuture.supplyAsync(() -> {
            List cachedLogs = LoggerCache.getLogs(databaseFilters, skip, limit).stream().sorted(Comparator.comparingLong(LogEntry::getCreatedAt).reversed()).collect(Collectors.toList());
            Map groupedResults = cachedLogs.stream().collect(Collectors.groupingBy(LocationCache::of, LinkedHashMap::new, Collectors.toCollection(LinkedHashSet::new)));
            int remaining = limit - cachedLogs.size();
            if (remaining > 0) {
                int dbSkip = skip + cachedLogs.size();
                CallbackLookup<Map<LocationCache, Set<LogEntry>>, Long> dbLookup = this.queryLogsFromDB(databaseFilters, dbSkip, remaining);
                List dbLogs = dbLookup.getLogs().values().stream().flatMap(Collection::stream).filter(log -> cachedLogs.stream().noneMatch(c -> c.equals(log))).sorted(Comparator.comparingLong(LogEntry::getCreatedAt).reversed()).limit(remaining).collect(Collectors.toList());
                Map dbGrouped = dbLogs.stream().collect(Collectors.groupingBy(LocationCache::of, LinkedHashMap::new, Collectors.toCollection(LinkedHashSet::new)));
                dbGrouped.forEach((location, logs) -> groupedResults.merge(location, logs, (existing, newLogs) -> {
                    existing.addAll(newLogs);
                    return existing;
                }));
                return new CallbackLookup<Map, Long>(groupedResults, dbLookup.getTotal());
            }
            long total = this.countLogs(databaseFilters);
            return new CallbackLookup<Map, Long>(groupedResults, total);
        }, (Executor)this.stellarProtect.getLookupExecutor());
    }

    @Override
    public CompletableFuture<CallbackLookup<Set<LogEntry>, Long>> getLogs(@NonNull Location location, int skip, int limit) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        return CompletableFuture.supplyAsync(() -> {
            List cachedLogs = LoggerCache.getLogs(LocationCache.of(location), skip, limit).stream().filter(log -> System.currentTimeMillis() - log.getCreatedAt() <= TimeUnit.MINUTES.toMillis(15L)).sorted(Comparator.comparingLong(LogEntry::getCreatedAt).reversed()).collect(Collectors.toList());
            LinkedHashSet result = new LinkedHashSet(cachedLogs);
            long totalCount = this.countLogsFromDB(location, null);
            int remaining = limit - cachedLogs.size();
            if (remaining > 0) {
                int dbSkip = skip + cachedLogs.size();
                CallbackLookup<Set<LogEntry>, Long> dbLookup = this.queryLogsFromDB(location, dbSkip, remaining, null);
                List dbLogs = dbLookup.getLogs().stream().filter(log -> cachedLogs.stream().noneMatch(c -> c.equals(log))).sorted(Comparator.comparingLong(LogEntry::getCreatedAt).reversed()).limit(remaining).collect(Collectors.toList());
                result.addAll(dbLogs);
            }
            Debugger.debugLog("getLogs: cached=" + cachedLogs.size() + ", total=" + totalCount + ", result=" + result.size());
            return new CallbackLookup(result, totalCount);
        }, (Executor)this.stellarProtect.getLookupExecutor());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long countLogsFromDB(Location location, @Nullable ActionType actionType) {
        String actionTypeFilter = actionType != null ? "AND ple.action_type = ? " : "";
        String countQuery = "SELECT COUNT(*) FROM " + this.stellarProtect.getConfigManager().getTablesLogEntries() + " ple JOIN " + this.stellarProtect.getConfigManager().getTablesPlayers() + " p ON ple.player_id = p.id WHERE ple.created_at BETWEEN ? AND ? AND ple.x = ? AND ple.y = ? AND ple.z = ? " + actionTypeFilter;
        long startTime = System.currentTimeMillis() - TimeUnit.DAYS.toMillis(30L);
        long endTime = System.currentTimeMillis();
        try (PreparedStatement countStmt = this.connection.prepareStatement(countQuery);){
            countStmt.setLong(1, startTime);
            countStmt.setLong(2, endTime);
            countStmt.setDouble(3, location.getBlockX());
            countStmt.setDouble(4, location.getBlockY());
            countStmt.setDouble(5, location.getBlockZ());
            if (actionType != null) {
                countStmt.setInt(6, actionType.getId());
            }
            try (ResultSet resultSet = countStmt.executeQuery();){
                if (!resultSet.next()) return 0L;
                long l = resultSet.getLong(1);
                return l;
            }
        }
        catch (SQLException e) {
            this.stellarProtect.getLogger().log(Level.SEVERE, "Error in countLogsFromDB", e);
        }
        return 0L;
    }

    private CallbackLookup<Set<LogEntry>, Long> queryLogsFromDB(Location location, int skip, int limit, @Nullable ActionType actionType) {
        LinkedHashSet<LogEntry> logs = new LinkedHashSet<LogEntry>();
        String actionTypeFilter = actionType != null ? "AND ple.action_type = ? " : "";
        String dataQuery = "SELECT ple.*, p.name, p.uuid FROM " + this.stellarProtect.getConfigManager().getTablesLogEntries() + " ple JOIN " + this.stellarProtect.getConfigManager().getTablesPlayers() + " p ON ple.player_id = p.id WHERE ple.created_at BETWEEN ? AND ? AND ple.x = ? AND ple.y = ? AND ple.z = ? " + actionTypeFilter + "ORDER BY ple.created_at DESC LIMIT ? OFFSET ?";
        long startTime = System.currentTimeMillis() - TimeUnit.DAYS.toMillis(30L);
        long endTime = System.currentTimeMillis();
        try (PreparedStatement dataStmt = this.connection.prepareStatement(dataQuery);){
            dataStmt.setLong(1, startTime);
            dataStmt.setLong(2, endTime);
            dataStmt.setDouble(3, location.getBlockX());
            dataStmt.setDouble(4, location.getBlockY());
            dataStmt.setDouble(5, location.getBlockZ());
            if (actionType != null) {
                dataStmt.setInt(6, actionType.getId());
                dataStmt.setInt(7, limit);
                dataStmt.setInt(8, skip);
            } else {
                dataStmt.setInt(6, limit);
                dataStmt.setInt(7, skip);
            }
            try (ResultSet rs = dataStmt.executeQuery();){
                while (rs.next()) {
                    long playerId = rs.getLong("player_id");
                    String playerName = rs.getString("name");
                    PlayerCache.cacheName(playerId, playerName);
                    logs.add(LogEntryFactory.fromDatabase(rs));
                }
            }
        }
        catch (SQLException e) {
            this.stellarProtect.getLogger().log(Level.SEVERE, "Error in queryLogsFromDB", e);
        }
        Debugger.debugLog("Loaded " + logs.size() + " logs from database.");
        return new CallbackLookup<Set<LogEntry>, Long>(logs, 0L);
    }

    private CallbackLookup<Map<LocationCache, Set<LogEntry>>, Long> queryLogsFromDB(DatabaseFilters databaseFilters, int skip, int limit) {
        QueryBuilder queryBuilder = this.buildBaseQuery(databaseFilters);
        String dataQuery = "SELECT ple.*, p.name, p.uuid " + queryBuilder.getFromAndWhere() + " ORDER BY ple.created_at DESC LIMIT ? OFFSET ?";
        String countQuery = "SELECT COUNT(*) " + queryBuilder.getFromAndWhere();
        long totalCount = this.executeCountQuery(countQuery, queryBuilder.getParameters());
        Set<LogEntry> logs = this.executeDataQuery(dataQuery, queryBuilder.getParameters(), limit, skip);
        Debugger.debugLog("Loaded " + logs.size() + " logs from database. Total count: " + totalCount);
        Map groupedLogs = logs.stream().collect(Collectors.groupingBy(LocationCache::of, LinkedHashMap::new, Collectors.toCollection(LinkedHashSet::new)));
        return new CallbackLookup<Map<LocationCache, Set<LogEntry>>, Long>(groupedLogs, totalCount);
    }

    public long countLogs(DatabaseFilters databaseFilters) {
        QueryBuilder queryBuilder = this.buildBaseQuery(databaseFilters);
        String countQuery = "SELECT COUNT(*) " + queryBuilder.getFromAndWhere();
        return this.executeCountQuery(countQuery, queryBuilder.getParameters());
    }

    private QueryBuilder buildBaseQuery(DatabaseFilters databaseFilters) {
        return new QueryBuilder(this.stellarProtect.getConfigManager().getTablesLogEntries(), this.stellarProtect.getConfigManager().getTablesPlayers()).addTimeFilter(databaseFilters.getTimeFilter()).addRadiusFilter(databaseFilters.getRadiusFilter()).addUsersFilter(databaseFilters.getUserFilters()).addActionTypesFilter(databaseFilters.getActionTypesFilter());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long executeCountQuery(String countQuery, List<Object> parameters) {
        try (PreparedStatement countStmt = this.connection.prepareStatement(countQuery);){
            this.setParameters(countStmt, parameters);
            try (ResultSet resultSet = countStmt.executeQuery();){
                if (!resultSet.next()) return 0L;
                long l = resultSet.getLong(1);
                return l;
            }
        }
        catch (SQLException e) {
            this.stellarProtect.getLogger().log(Level.SEVERE, "Error in count query", e);
        }
        return 0L;
    }

    private Set<LogEntry> executeDataQuery(String dataQuery, List<Object> parameters, int limit, int skip) {
        LinkedHashSet<LogEntry> logs = new LinkedHashSet<LogEntry>();
        try (PreparedStatement dataStmt = this.connection.prepareStatement(dataQuery);){
            ArrayList<Object> allParams = new ArrayList<Object>(parameters);
            allParams.add(limit);
            allParams.add(skip);
            this.setParameters(dataStmt, allParams);
            try (ResultSet rs = dataStmt.executeQuery();){
                while (rs.next()) {
                    long playerId = rs.getLong("player_id");
                    String playerName = rs.getString("name");
                    PlayerCache.cacheName(playerId, playerName);
                    logs.add(LogEntryFactory.fromDatabase(rs));
                }
            }
        }
        catch (SQLException e) {
            this.stellarProtect.getLogger().log(Level.SEVERE, "Error in data query", e);
        }
        return logs;
    }

    private void setParameters(PreparedStatement stmt, List<Object> parameters) throws SQLException {
        for (int i = 0; i < parameters.size(); ++i) {
            Object param = parameters.get(i);
            if (param instanceof Long) {
                stmt.setLong(i + 1, (Long)param);
                continue;
            }
            if (param instanceof Double) {
                stmt.setDouble(i + 1, (Double)param);
                continue;
            }
            if (param instanceof Integer) {
                stmt.setInt(i + 1, (Integer)param);
                continue;
            }
            stmt.setObject(i + 1, param);
        }
    }

    private static class QueryBuilder {
        private final List<String> whereConditions = new ArrayList<String>();
        private final List<Object> parameters = new ArrayList<Object>();
        private final String tablesLogEntries;
        private final String tablesPlayers;

        public QueryBuilder(String tablesLogEntries, String tablesPlayers) {
            this.tablesLogEntries = tablesLogEntries;
            this.tablesPlayers = tablesPlayers;
        }

        public QueryBuilder addTimeFilter(TimeArg timeArg) {
            if (timeArg != null) {
                this.whereConditions.add("ple.created_at BETWEEN ? AND ?");
                this.parameters.add(timeArg.getStart());
                this.parameters.add(timeArg.getEnd());
            }
            return this;
        }

        public QueryBuilder addRadiusFilter(RadiusArg radiusArg) {
            if (radiusArg != null) {
                this.whereConditions.add("ple.x BETWEEN ? AND ?");
                this.whereConditions.add("ple.y BETWEEN ? AND ?");
                this.whereConditions.add("ple.z BETWEEN ? AND ?");
                this.parameters.add(radiusArg.getMinX());
                this.parameters.add(radiusArg.getMaxX());
                this.parameters.add(radiusArg.getMinY());
                this.parameters.add(radiusArg.getMaxY());
                this.parameters.add(radiusArg.getMinZ());
                this.parameters.add(radiusArg.getMaxZ());
            }
            return this;
        }

        public QueryBuilder addUsersFilter(UsersArg usersArg) {
            if (usersArg != null && usersArg.getUserIds() != null && !usersArg.getUserIds().isEmpty()) {
                String placeholders = usersArg.getUserIds().stream().map(id -> "?").collect(Collectors.joining(","));
                this.whereConditions.add("ple.player_id IN (" + placeholders + ")");
                this.parameters.addAll(usersArg.getUserIds());
            }
            return this;
        }

        public QueryBuilder addActionTypesFilter(List<Integer> actionTypes) {
            if (actionTypes != null && !actionTypes.isEmpty()) {
                String placeholders = actionTypes.stream().map(type -> "?").collect(Collectors.joining(","));
                this.whereConditions.add("ple.action_type IN (" + placeholders + ")");
                this.parameters.addAll(actionTypes);
            }
            return this;
        }

        public String getFromAndWhere() {
            String whereClause = this.whereConditions.isEmpty() ? "" : " WHERE " + String.join((CharSequence)" AND ", this.whereConditions);
            return "FROM " + this.tablesLogEntries + " ple JOIN " + this.tablesPlayers + " p ON ple.player_id = p.id" + whereClause;
        }

        public List<Object> getParameters() {
            return new ArrayList<Object>(this.parameters);
        }
    }
}

