/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.enums;

import io.github.InsiderAnh.StellarProtect.enums.ActionType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;

public enum ActionCategory {
    BLOCK_ACTIONS(0, "block_actions", new ActionType[]{ActionType.BLOCK_BREAK, ActionType.BLOCK_PLACE, ActionType.BLOCK_USE}),
    ITEM_ACTIONS(1, "item_actions", new ActionType[]{ActionType.DROP_ITEM, ActionType.PICKUP_ITEM, ActionType.FURNACE_EXTRACT, ActionType.FURNACE_PLACE, ActionType.ENCHANT, ActionType.REPAIR, ActionType.SMITH, ActionType.BREWING}),
    ENTITY_ACTIONS(2, "entity_actions", new ActionType[]{ActionType.KILL_ENTITY, ActionType.DEATH, ActionType.INTERACT, ActionType.USE, ActionType.TAME, ActionType.BREED, ActionType.MOUNT, ActionType.RAID}),
    SYSTEM_ACTIONS(3, "system_actions", new ActionType[]{ActionType.CROP_GROW, ActionType.CRAFT}),
    COMMUNICATION_ACTIONS(4, "communication_actions", new ActionType[]{ActionType.CHAT, ActionType.COMMAND}),
    FLUID_ACTIONS(5, "fluid_actions", new ActionType[]{ActionType.BUCKET_EMPTY, ActionType.BUCKET_FILL}),
    INVENTORY_ACTIONS(6, "inventory_actions", new ActionType[]{ActionType.INVENTORY_TRANSACTION}),
    SESSION_ACTIONS(7, "session_actions", new ActionType[]{ActionType.SESSION}),
    SIGN_ACTIONS(8, "sign_actions", new ActionType[]{ActionType.SIGN_CHANGE}),
    PLAYER_ACTIONS(9, "player_actions", new ActionType[]{ActionType.SHOOT, ActionType.TOTEM}),
    UNKNOWN_ACTIONS(50, "unknown_actions", new ActionType[]{ActionType.BLOCK_BREAK, ActionType.BLOCK_PLACE, ActionType.BLOCK_USE, ActionType.DROP_ITEM, ActionType.PICKUP_ITEM, ActionType.FURNACE_EXTRACT, ActionType.FURNACE_PLACE, ActionType.KILL_ENTITY, ActionType.INTERACT, ActionType.USE, ActionType.TAME, ActionType.BREED, ActionType.CROP_GROW, ActionType.CRAFT, ActionType.CHAT, ActionType.COMMAND, ActionType.BUCKET_EMPTY, ActionType.BUCKET_FILL, ActionType.INVENTORY_TRANSACTION, ActionType.SESSION, ActionType.SIGN_CHANGE, ActionType.ENCHANT, ActionType.REPAIR, ActionType.DEATH, ActionType.MOUNT, ActionType.RAID, ActionType.HANGING, ActionType.SMITH, ActionType.BREWING, ActionType.SHOOT, ActionType.TOTEM});

    private final int id;
    private final String tableName;
    private final ActionType[] actions;
    private final Set<ActionType> actionSet;

    private ActionCategory(int id, String tableName, ActionType[] actions) {
        this.id = id;
        this.tableName = tableName;
        this.actions = actions;
        this.actionSet = new HashSet<ActionType>();
        this.actionSet.addAll(Arrays.asList(actions));
    }

    public static Set<ActionCategory> fromActionTypes(List<ActionType> actionTypes) {
        HashSet<ActionCategory> categories = new HashSet<ActionCategory>();
        for (ActionCategory category : ActionCategory.values()) {
            for (ActionType action : category.actionSet) {
                if (!actionTypes.contains((Object)action)) continue;
                categories.add(category);
            }
        }
        return categories;
    }

    public static ActionCategory fromActionTypes(ActionType actionType) {
        for (ActionCategory category : ActionCategory.values()) {
            if (!category.actionSet.contains((Object)actionType)) continue;
            return category;
        }
        return SYSTEM_ACTIONS;
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public ActionType[] getActions() {
        return this.actions;
    }

    @Generated
    public Set<ActionType> getActionSet() {
        return this.actionSet;
    }
}

