/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.enums;

import io.github.InsiderAnh.StellarProtect.config.WorldConfigType;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.lang.Nullable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;

public enum ActionType {
    BLOCK_BREAK(0),
    BLOCK_PLACE(1),
    BLOCK_USE(2),
    DROP_ITEM(3),
    PICKUP_ITEM(4),
    FURNACE_EXTRACT(5),
    FURNACE_PLACE(6),
    CRAFT(7),
    ENCHANT(21),
    CROP_GROW(8),
    KILL_ENTITY(9),
    INTERACT(10),
    TAME(11),
    BREED(12),
    CHAT(13),
    COMMAND(14),
    BUCKET_EMPTY(15),
    BUCKET_FILL(16),
    INVENTORY_TRANSACTION(17),
    USE(18),
    SESSION(19),
    SIGN_CHANGE(20),
    DEATH(23),
    MOUNT(24),
    RAID(25),
    HANGING(26),
    SMITH(27),
    BREWING(28),
    REPAIR(29),
    SHOOT(30),
    TOTEM(31);

    private final int id;
    private final HashMap<String, WorldConfigType> worldTypes = new HashMap();
    private final HashSet<String> worlds = new HashSet();
    private final HashSet<String> disabledTypes = new HashSet();
    private boolean enabled = true;

    private ActionType(int id) {
        this.id = id;
    }

    public static ActionType getById(int id) {
        for (ActionType actionType : ActionType.values()) {
            if (actionType.getId() != id) continue;
            return actionType;
        }
        return null;
    }

    public static ActionType getByName(String name) {
        for (ActionType actionType : ActionType.values()) {
            if (!actionType.name().equalsIgnoreCase(name)) continue;
            return actionType;
        }
        return null;
    }

    public static List<String> getAllNamesNoPrefix(@Nullable String filter) {
        LinkedList<String> names = new LinkedList<String>();
        for (ActionType actionType : ActionType.values()) {
            if (filter != null && !actionType.name().toLowerCase().contains(filter)) continue;
            names.add(actionType.name().toLowerCase());
        }
        return names;
    }

    public static List<String> getAllNames(@Nullable String filter) {
        LinkedList<String> names = new LinkedList<String>();
        for (ActionType actionType : ActionType.values()) {
            if (filter != null && !actionType.name().toLowerCase().contains(filter)) continue;
            names.add("a:" + actionType.name().toLowerCase());
        }
        return names;
    }

    public boolean shouldSkipLog(String world, String type) {
        WorldConfigType worldConfigType = this.worldTypes.get(world);
        if (worldConfigType != null) {
            return !worldConfigType.isEnabled() || worldConfigType.getDisabledTypes().contains(type.toLowerCase());
        }
        return !this.enabled || this.disabledTypes.contains(type.toLowerCase()) || !this.worlds.contains("all") && !this.worlds.contains(world.toLowerCase());
    }

    public boolean shouldSkipLogStart(@Nullable String world, String type) {
        WorldConfigType worldConfigType = this.worldTypes.get(world);
        if (worldConfigType != null) {
            for (String disabledType : worldConfigType.getDisabledTypes()) {
                if (!disabledType.startsWith(type.toLowerCase())) continue;
                return true;
            }
            return !worldConfigType.isEnabled();
        }
        for (String disabledType : this.disabledTypes) {
            if (!disabledType.startsWith(type.toLowerCase())) continue;
            return true;
        }
        return !this.enabled || !this.worlds.contains("all") && world != null && !this.worlds.contains(world.toLowerCase());
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public HashMap<String, WorldConfigType> getWorldTypes() {
        return this.worldTypes;
    }

    @Generated
    public HashSet<String> getWorlds() {
        return this.worlds;
    }

    @Generated
    public HashSet<String> getDisabledTypes() {
        return this.disabledTypes;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

