/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.libs.mongodb.client.internal;

import io.github.InsiderAnh.StellarProtect.libs.mongodb.AutoEncryptionSettings;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.ClientEncryptionSettings;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.MongoClientException;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.MongoClientSettings;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.MongoNamespace;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.MongoClients;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.internal.CollectionInfoRetriever;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.internal.CommandMarker;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.internal.Crypt;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.internal.KeyManagementService;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.internal.KeyRetriever;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.internal.SimpleMongoClient;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.internal.SimpleMongoClients;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.crypt.capi.MongoCryptOptions;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.crypt.capi.MongoCrypts;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.capi.MongoCryptHelper;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;

public final class Crypts {
    public static Crypt createCrypt(SimpleMongoClient client, AutoEncryptionSettings options) {
        return new Crypt(MongoCrypts.create((MongoCryptOptions)MongoCryptHelper.createMongoCryptOptions(options.getKmsProviders(), options.getSchemaMap())), new CollectionInfoRetriever(client), new CommandMarker(options.isBypassAutoEncryption(), options.getExtraOptions()), Crypts.createKeyRetriever(client, options.getKeyVaultMongoClientSettings(), options.getKeyVaultNamespace()), Crypts.createKeyManagementService(), options.isBypassAutoEncryption());
    }

    static Crypt create(SimpleMongoClient keyVaultClient, ClientEncryptionSettings options) {
        return new Crypt(MongoCrypts.create((MongoCryptOptions)MongoCryptHelper.createMongoCryptOptions(options.getKmsProviders(), null)), Crypts.createKeyRetriever(keyVaultClient, false, options.getKeyVaultNamespace()), Crypts.createKeyManagementService());
    }

    private static KeyRetriever createKeyRetriever(SimpleMongoClient defaultKeyVaultClient, MongoClientSettings keyVaultMongoClientSettings, String keyVaultNamespaceString) {
        boolean keyRetrieverOwnsClient;
        SimpleMongoClient keyVaultClient;
        if (keyVaultMongoClientSettings != null) {
            keyVaultClient = SimpleMongoClients.create(MongoClients.create(keyVaultMongoClientSettings));
            keyRetrieverOwnsClient = true;
        } else {
            keyVaultClient = defaultKeyVaultClient;
            keyRetrieverOwnsClient = false;
        }
        return Crypts.createKeyRetriever(keyVaultClient, keyRetrieverOwnsClient, keyVaultNamespaceString);
    }

    private static KeyRetriever createKeyRetriever(SimpleMongoClient keyVaultClient, boolean keyRetrieverOwnsClient, String keyVaultNamespaceString) {
        return new KeyRetriever(keyVaultClient, keyRetrieverOwnsClient, new MongoNamespace(keyVaultNamespaceString));
    }

    private static KeyManagementService createKeyManagementService() {
        return new KeyManagementService(Crypts.getSslContext(), 443, 10000);
    }

    private static SSLContext getSslContext() {
        SSLContext sslContext;
        try {
            sslContext = SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException e) {
            throw new MongoClientException("Unable to create default SSLContext", e);
        }
        return sslContext;
    }

    private Crypts() {
    }
}

