/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection;

import io.github.InsiderAnh.StellarProtect.libs.mongodb.connection.ClusterId;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.connection.ServerSettings;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.DefaultDnsSrvRecordMonitor;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.DnsSrvRecordInitializer;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.DnsSrvRecordMonitor;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.DnsSrvRecordMonitorFactory;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.dns.DefaultDnsResolver;
import java.util.concurrent.TimeUnit;

public class DefaultDnsSrvRecordMonitorFactory
implements DnsSrvRecordMonitorFactory {
    private static final long DEFAULT_RESCAN_FREQUENCY_MILLIS = 60000L;
    private final ClusterId clusterId;
    private final long noRecordsRescanFrequency;

    public DefaultDnsSrvRecordMonitorFactory(ClusterId clusterId, ServerSettings serverSettings) {
        this.clusterId = clusterId;
        this.noRecordsRescanFrequency = serverSettings.getHeartbeatFrequency(TimeUnit.MILLISECONDS);
    }

    @Override
    public DnsSrvRecordMonitor create(String hostName, DnsSrvRecordInitializer dnsSrvRecordInitializer) {
        return new DefaultDnsSrvRecordMonitor(hostName, 60000L, this.noRecordsRescanFrequency, dnsSrvRecordInitializer, this.clusterId, new DefaultDnsResolver());
    }
}

