/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.listeners;

import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.cache.LoggerCache;
import io.github.InsiderAnh.StellarProtect.cache.PlayerCache;
import io.github.InsiderAnh.StellarProtect.data.PlayerProtect;
import io.github.InsiderAnh.StellarProtect.database.entries.players.PlayerDeathEntry;
import io.github.InsiderAnh.StellarProtect.database.entries.players.PlayerHangingEntry;
import io.github.InsiderAnh.StellarProtect.database.entries.players.PlayerKillLogEntry;
import io.github.InsiderAnh.StellarProtect.database.entries.players.PlayerMountEntry;
import io.github.InsiderAnh.StellarProtect.database.entries.players.PlayerShootEntry;
import io.github.InsiderAnh.StellarProtect.enums.ActionType;
import io.github.InsiderAnh.StellarProtect.enums.DeathCause;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.spigotmc.event.entity.EntityDismountEvent;
import org.spigotmc.event.entity.EntityMountEvent;

public class PlayerLogListener
implements Listener {
    private final StellarProtect plugin = StellarProtect.getInstance();

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.getKiller() == null) {
            return;
        }
        if (ActionType.KILL_ENTITY.shouldSkipLog(entity.getWorld().getName(), entity.getType().name())) {
            return;
        }
        Player killer = entity.getKiller();
        PlayerProtect playerProtect = PlayerProtect.getPlayer(killer);
        if (playerProtect == null) {
            return;
        }
        LoggerCache.addLog(new PlayerKillLogEntry(playerProtect.getPlayerId(), (Entity)entity, ActionType.KILL_ENTITY));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerDeath(PlayerDeathEvent event) {
        if (ActionType.DEATH.shouldSkipLog(event.getEntity().getWorld().getName(), event.getEntity().getType().name())) {
            return;
        }
        Player player = event.getEntity();
        PlayerProtect playerProtect = PlayerProtect.getPlayer(player);
        if (playerProtect == null) {
            return;
        }
        DeathCause cause = DeathCause.getById(this.getCause(player));
        PlayerDeathEntry deathEntry = new PlayerDeathEntry(playerProtect.getPlayerId(), player.getLocation(), cause.getId());
        LoggerCache.addLog(deathEntry);
        PlayerCache.checkPattern(deathEntry);
    }

    @EventHandler
    public void onLaunchProjectile(ProjectileLaunchEvent event) {
        if (!(event.getEntity().getShooter() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity().getShooter();
        if (ActionType.SHOOT.shouldSkipLog(player.getWorld().getName(), event.getEntity().getType().name())) {
            return;
        }
        PlayerProtect playerProtect = PlayerProtect.getPlayer(player);
        if (playerProtect == null) {
            return;
        }
        PlayerShootEntry shootEntry = new PlayerShootEntry(playerProtect.getPlayerId(), player.getLocation(), (Entity)event.getEntity(), false);
        LoggerCache.addLog(shootEntry);
    }

    @EventHandler
    public void onDamageByEntity(EntityDamageByEntityEvent event) {
        if (!(event.getDamager() instanceof Projectile)) {
            return;
        }
        Projectile projectile = (Projectile)event.getDamager();
        if (ActionType.SHOOT.shouldSkipLog(projectile.getWorld().getName(), projectile.getType().name())) {
            return;
        }
        if (!(projectile.getShooter() instanceof Player)) {
            return;
        }
        Player player = (Player)projectile.getShooter();
        PlayerProtect playerProtect = PlayerProtect.getPlayer(player);
        if (playerProtect == null) {
            return;
        }
        PlayerShootEntry shootEntry = new PlayerShootEntry(playerProtect.getPlayerId(), player.getLocation(), (Entity)projectile, event.getEntity(), true);
        LoggerCache.addLog(shootEntry);
    }

    @EventHandler
    public void onHangingBreak(HangingBreakByEntityEvent event) {
        if (!(event.getRemover() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getRemover();
        if (ActionType.HANGING.shouldSkipLog(player.getWorld().getName(), event.getEntity().getType().name())) {
            return;
        }
        PlayerProtect playerProtect = PlayerProtect.getPlayer(player);
        if (playerProtect == null) {
            return;
        }
        PlayerHangingEntry hangingEntry = new PlayerHangingEntry(playerProtect.getPlayerId(), player.getLocation(), (Entity)event.getEntity());
        LoggerCache.addLog(hangingEntry);
    }

    @EventHandler
    public void onMount(EntityMountEvent event) {
        if (!(event.getMount() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getMount();
        if (ActionType.MOUNT.shouldSkipLog(player.getWorld().getName(), event.getEntity().getType().name())) {
            return;
        }
        PlayerProtect playerProtect = PlayerProtect.getPlayer(player);
        if (playerProtect == null) {
            return;
        }
        PlayerMountEntry mountEntry = new PlayerMountEntry(playerProtect.getPlayerId(), player.getLocation(), event.getEntity(), true);
        LoggerCache.addLog(mountEntry);
    }

    @EventHandler
    public void onDismount(EntityDismountEvent event) {
        if (!(event.getDismounted() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getDismounted();
        if (ActionType.MOUNT.shouldSkipLog(player.getWorld().getName(), event.getEntity().getType().name())) {
            return;
        }
        PlayerProtect playerProtect = PlayerProtect.getPlayer(player);
        if (playerProtect == null) {
            return;
        }
        PlayerMountEntry mountEntry = new PlayerMountEntry(playerProtect.getPlayerId(), player.getLocation(), event.getEntity(), false);
        LoggerCache.addLog(mountEntry);
    }

    public String getCause(Player player) {
        EntityDamageEvent event = player.getLastDamageCause();
        if (event == null) {
            return "UNKNOWN";
        }
        if (event.getCause() == null) {
            return "UNKNOWN";
        }
        return event.getCause().name();
    }
}

