/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.listeners.versions;

import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.api.events.EventLogicHandler;
import io.github.InsiderAnh.StellarProtect.cache.LoggerCache;
import io.github.InsiderAnh.StellarProtect.data.PlayerProtect;
import io.github.InsiderAnh.StellarProtect.database.entries.players.PlayerBlockLogEntry;
import io.github.InsiderAnh.StellarProtect.database.entries.players.PlayerItemLogEntry;
import io.github.InsiderAnh.StellarProtect.enums.ActionType;
import io.github.InsiderAnh.StellarProtect.items.ItemReference;
import io.github.InsiderAnh.StellarProtect.utils.PlayerUtils;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class EventVersionHandler
implements EventLogicHandler {
    private final StellarProtect plugin = StellarProtect.getInstance();

    @Override
    public void onPortalCreate(List<Block> blocks) {
        for (Block block : blocks) {
            if (ActionType.BLOCK_PLACE.shouldSkipLog(block.getWorld().getName(), block.getType().name())) {
                return;
            }
            LoggerCache.addLog(new PlayerBlockLogEntry(PlayerUtils.getEntityId("=portal"), block, ActionType.BLOCK_PLACE));
        }
    }

    @Override
    public void onSmithEvent(HumanEntity humanEntity, ItemStack result) {
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (ActionType.SMITH.shouldSkipLog(player.getWorld().getName(), result.getType().name())) {
            return;
        }
        PlayerProtect playerProtect = PlayerProtect.getPlayer(player);
        if (playerProtect == null) {
            return;
        }
        ItemReference itemReference = this.plugin.getItemsManager().getItemReference(result);
        LoggerCache.addLog(new PlayerItemLogEntry(playerProtect.getPlayerId(), itemReference, player.getLocation(), ActionType.SMITH));
    }

    @Override
    public void onBrewEvent(ItemStack ingredient, ItemStack fuel, List<ItemStack> results) {
    }
}

