/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.commands.arguments;

import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.cache.LoggerCache;
import io.github.InsiderAnh.StellarProtect.commands.StellarArgument;
import io.github.InsiderAnh.StellarProtect.items.ItemTemplate;
import io.github.InsiderAnh.StellarProtect.items.MemoryAnalysisItem;
import io.github.InsiderAnh.StellarProtect.items.memory.ItemTemplateLight;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.openjdk.jol.info.GraphLayout;

public class MemoryArgument
extends StellarArgument {
    private final StellarProtect plugin = StellarProtect.getInstance();

    @Override
    public void onCommand(@NotNull CommandSender sender, String[] arguments) {
        boolean footprint = arguments.length > 0 && arguments[0].equalsIgnoreCase("footprint");
        sender.sendMessage("\u00a7aLoading memory analysis...");
        this.plugin.getLookupExecutor().execute(() -> {
            LinkedHashMap<String, MemoryAnalysisItem> memoryObjects = new LinkedHashMap<String, MemoryAnalysisItem>();
            HashMap idToTemplate = this.plugin.getItemsManager().getIdToTemplate().entrySet().stream().collect(HashMap::new, (map, entry) -> map.put(((Long)entry.getKey()).toString(), new ItemTemplateLight((Long)entry.getKey(), ((ItemTemplate)entry.getValue()).getBase64())), HashMap::putAll);
            memoryObjects.put("messages.memory.itemTemplates", new MemoryAnalysisItem(idToTemplate));
            memoryObjects.put("messages.memory.cachedLogsByCategory", new MemoryAnalysisItem(LoggerCache.getCachedLogsByCategory()));
            memoryObjects.put("messages.memory.unSavedLogsByCategory", new MemoryAnalysisItem(LoggerCache.getUnSavedLogsByCategory()));
            memoryObjects.put("messages.memory.placedBlockLogs", new MemoryAnalysisItem(LoggerCache.getPlacedBlockLogs()));
            memoryObjects.put("messages.memory.playerRecentActions", new MemoryAnalysisItem(LoggerCache.getPlayerRecentActions()));
            memoryObjects.put("messages.memory.queryCache", new MemoryAnalysisItem(LoggerCache.getQueryCache()));
            sender.sendMessage(this.plugin.getLangManager().get("messages.memory.title"));
            long totalMemoryUsage = 0L;
            for (Map.Entry entry2 : memoryObjects.entrySet()) {
                String messageKey = (String)entry2.getKey();
                MemoryAnalysisItem item = (MemoryAnalysisItem)entry2.getValue();
                sender.sendMessage(this.plugin.getLangManager().get(messageKey));
                if (footprint) {
                    sender.sendMessage(this.plugin.getLangManager().get("messages.memory.footprint"));
                    sender.sendMessage(GraphLayout.parseInstance(item.getObject()).toFootprint());
                }
                long sizeInBytes = GraphLayout.parseInstance(item.getObject()).totalSize();
                String formattedSize = this.formatMemorySize(sizeInBytes);
                sender.sendMessage(this.plugin.getLangManager().get("messages.memory.total") + " " + formattedSize);
                sender.sendMessage("");
                totalMemoryUsage += sizeInBytes;
            }
            sender.sendMessage(this.plugin.getLangManager().get("messages.memory.summary.title"));
            sender.sendMessage(this.plugin.getLangManager().get("messages.memory.summary.totalMemory") + this.formatMemorySize(totalMemoryUsage));
            sender.sendMessage(this.plugin.getLangManager().get("messages.memory.summary.objectsAnalyzed") + memoryObjects.size());
        });
    }

    @Override
    public List<String> onTabComplete(@NotNull CommandSender sender, String[] arguments) {
        return new LinkedList<String>(Collections.singletonList("footprint"));
    }

    private String formatMemorySize(long bytes) {
        if (bytes < 1024L) {
            return "\u00a7f" + bytes + " \u00a77bytes";
        }
        double kb = (double)bytes / 1024.0;
        if (kb < 1024.0) {
            return String.format("\u00a7f%.2f \u00a77KB \u00a78(\u00a7f%d \u00a77bytes\u00a78)", kb, bytes);
        }
        double mb = kb / 1024.0;
        if (mb < 1024.0) {
            return String.format("\u00a7f%.2f \u00a77MB \u00a78(\u00a7f%.2f \u00a77KB\u00a78)", mb, kb);
        }
        double gb = mb / 1024.0;
        return String.format("\u00a7f%.2f \u00a77GB \u00a78(\u00a7f%.2f \u00a77MB\u00a78)", gb, mb);
    }
}

