/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.libs.mongodb.operation;

import io.github.InsiderAnh.StellarProtect.libs.bson.BsonBoolean;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonDocument;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonInt32;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.MongoWriteConcernException;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.ServerAddress;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.WriteConcernResult;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.connection.AsyncConnection;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.connection.Connection;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.operation.WriteConcernHelper;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.operation.BsonDocumentWrapperHelper;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.operation.CommandOperationHelper;

final class FindAndModifyHelper {
    static <T> CommandOperationHelper.CommandWriteTransformer<BsonDocument, T> transformer() {
        return new CommandOperationHelper.CommandWriteTransformer<BsonDocument, T>(){

            @Override
            public T apply(BsonDocument result, Connection connection) {
                return FindAndModifyHelper.transformDocument(result, connection.getDescription().getServerAddress());
            }
        };
    }

    static <T> CommandOperationHelper.CommandWriteTransformerAsync<BsonDocument, T> asyncTransformer() {
        return new CommandOperationHelper.CommandWriteTransformerAsync<BsonDocument, T>(){

            @Override
            public T apply(BsonDocument result, AsyncConnection connection) {
                return FindAndModifyHelper.transformDocument(result, connection.getDescription().getServerAddress());
            }
        };
    }

    private static <T> T transformDocument(BsonDocument result, ServerAddress serverAddress) {
        if (WriteConcernHelper.hasWriteConcernError(result)) {
            throw new MongoWriteConcernException(WriteConcernHelper.createWriteConcernError(result.getDocument("writeConcernError")), FindAndModifyHelper.createWriteConcernResult(result.getDocument("lastErrorObject", new BsonDocument())), serverAddress);
        }
        if (!result.isDocument("value")) {
            return null;
        }
        return BsonDocumentWrapperHelper.toDocument(result.getDocument("value", null));
    }

    private static WriteConcernResult createWriteConcernResult(BsonDocument result) {
        BsonBoolean updatedExisting = result.getBoolean("updatedExisting", BsonBoolean.FALSE);
        return WriteConcernResult.acknowledged(result.getNumber("n", new BsonInt32(0)).intValue(), updatedExisting.getValue(), result.get("upserted"));
    }

    private FindAndModifyHelper() {
    }
}

