/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.libs.mongodb.operation;

import io.github.InsiderAnh.StellarProtect.libs.bson.BsonDocument;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonInt32;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonJavaScript;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonNull;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonString;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonValue;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.BsonDocumentCodec;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.Decoder;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.ExplainVerbosity;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.MongoNamespace;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.assertions.Assertions;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.async.SingleResultCallback;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.binding.AsyncConnectionSource;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.binding.AsyncReadBinding;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.binding.ConnectionSource;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.binding.ReadBinding;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.model.Collation;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.connection.AsyncConnection;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.connection.Connection;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.connection.ConnectionDescription;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.connection.QueryResult;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.connection.ServerDescription;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.async.ErrorHandlingResultCallback;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.NoOpSessionContext;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.operation.AsyncReadOperation;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.operation.BsonDocumentWrapperHelper;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.operation.CommandOperationHelper;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.operation.CommandReadOperation;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.operation.CommandResultDocumentCodec;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.operation.DocumentHelper;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.operation.ExplainHelper;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.operation.MapReduceAsyncBatchCursor;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.operation.MapReduceBatchCursor;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.operation.MapReduceHelper;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.operation.MapReduceInlineResultsAsyncCursor;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.operation.MapReduceInlineResultsCursor;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.operation.OperationHelper;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.operation.OperationReadConcernHelper;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.operation.ReadOperation;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.session.SessionContext;
import java.util.concurrent.TimeUnit;

@Deprecated
public class MapReduceWithInlineResultsOperation<T>
implements AsyncReadOperation<MapReduceAsyncBatchCursor<T>>,
ReadOperation<MapReduceBatchCursor<T>> {
    private final MongoNamespace namespace;
    private final BsonJavaScript mapFunction;
    private final BsonJavaScript reduceFunction;
    private final Decoder<T> decoder;
    private BsonJavaScript finalizeFunction;
    private BsonDocument scope;
    private BsonDocument filter;
    private BsonDocument sort;
    private int limit;
    private boolean jsMode;
    private boolean verbose;
    private long maxTimeMS;
    private Collation collation;

    public MapReduceWithInlineResultsOperation(MongoNamespace namespace, BsonJavaScript mapFunction, BsonJavaScript reduceFunction, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.mapFunction = Assertions.notNull("mapFunction", mapFunction);
        this.reduceFunction = Assertions.notNull("reduceFunction", reduceFunction);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public Decoder<T> getDecoder() {
        return this.decoder;
    }

    public BsonJavaScript getMapFunction() {
        return this.mapFunction;
    }

    public BsonJavaScript getReduceFunction() {
        return this.reduceFunction;
    }

    public BsonJavaScript getFinalizeFunction() {
        return this.finalizeFunction;
    }

    public MapReduceWithInlineResultsOperation<T> finalizeFunction(BsonJavaScript finalizeFunction) {
        this.finalizeFunction = finalizeFunction;
        return this;
    }

    public BsonDocument getScope() {
        return this.scope;
    }

    public MapReduceWithInlineResultsOperation<T> scope(BsonDocument scope) {
        this.scope = scope;
        return this;
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public MapReduceWithInlineResultsOperation<T> filter(BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public BsonDocument getSort() {
        return this.sort;
    }

    public MapReduceWithInlineResultsOperation<T> sort(BsonDocument sort) {
        this.sort = sort;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public MapReduceWithInlineResultsOperation<T> limit(int limit) {
        this.limit = limit;
        return this;
    }

    public boolean isJsMode() {
        return this.jsMode;
    }

    public MapReduceWithInlineResultsOperation<T> jsMode(boolean jsMode) {
        this.jsMode = jsMode;
        return this;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public MapReduceWithInlineResultsOperation<T> verbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public MapReduceWithInlineResultsOperation<T> collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public MapReduceWithInlineResultsOperation<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public MapReduceBatchCursor<T> execute(ReadBinding binding) {
        return CommandOperationHelper.executeCommand(binding, this.namespace.getDatabaseName(), this.getCommandCreator(binding.getSessionContext()), CommandResultDocumentCodec.create(this.decoder, "results"), this.transformer(), false);
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<MapReduceAsyncBatchCursor<T>> callback) {
        SingleResultCallback<MapReduceAsyncBatchCursor<T>> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
        CommandOperationHelper.executeCommandAsync(binding, this.namespace.getDatabaseName(), this.getCommandCreator(binding.getSessionContext()), CommandResultDocumentCodec.create(this.decoder, "results"), this.asyncTransformer(), false, errHandlingCallback);
    }

    public ReadOperation<BsonDocument> asExplainableOperation(ExplainVerbosity explainVerbosity) {
        return this.createExplainableOperation(explainVerbosity);
    }

    public AsyncReadOperation<BsonDocument> asExplainableOperationAsync(ExplainVerbosity explainVerbosity) {
        return this.createExplainableOperation(explainVerbosity);
    }

    private CommandReadOperation<BsonDocument> createExplainableOperation(ExplainVerbosity explainVerbosity) {
        return new CommandReadOperation<BsonDocument>(this.namespace.getDatabaseName(), ExplainHelper.asExplainCommand(this.getCommand(NoOpSessionContext.INSTANCE), explainVerbosity), new BsonDocumentCodec());
    }

    private CommandOperationHelper.CommandReadTransformer<BsonDocument, MapReduceBatchCursor<T>> transformer() {
        return new CommandOperationHelper.CommandReadTransformer<BsonDocument, MapReduceBatchCursor<T>>(){

            @Override
            public MapReduceBatchCursor<T> apply(BsonDocument result, ConnectionSource source, Connection connection) {
                return new MapReduceInlineResultsCursor(MapReduceWithInlineResultsOperation.this.createQueryResult(result, connection.getDescription()), MapReduceWithInlineResultsOperation.this.decoder, source, MapReduceHelper.createStatistics(result));
            }
        };
    }

    private CommandOperationHelper.CommandReadTransformerAsync<BsonDocument, MapReduceAsyncBatchCursor<T>> asyncTransformer() {
        return new CommandOperationHelper.CommandReadTransformerAsync<BsonDocument, MapReduceAsyncBatchCursor<T>>(){

            @Override
            public MapReduceAsyncBatchCursor<T> apply(BsonDocument result, AsyncConnectionSource source, AsyncConnection connection) {
                return new MapReduceInlineResultsAsyncCursor(MapReduceWithInlineResultsOperation.this.createQueryResult(result, connection.getDescription()), MapReduceHelper.createStatistics(result));
            }
        };
    }

    private CommandOperationHelper.CommandCreator getCommandCreator(final SessionContext sessionContext) {
        return new CommandOperationHelper.CommandCreator(){

            @Override
            public BsonDocument create(ServerDescription serverDescription, ConnectionDescription connectionDescription) {
                OperationHelper.validateReadConcernAndCollation(connectionDescription, sessionContext.getReadConcern(), MapReduceWithInlineResultsOperation.this.collation);
                return MapReduceWithInlineResultsOperation.this.getCommand(sessionContext);
            }
        };
    }

    private BsonDocument getCommand(SessionContext sessionContext) {
        BsonDocument commandDocument = new BsonDocument("mapreduce", new BsonString(this.namespace.getCollectionName())).append("map", this.getMapFunction()).append("reduce", this.getReduceFunction()).append("out", new BsonDocument("inline", new BsonInt32(1)));
        DocumentHelper.putIfNotNull(commandDocument, "query", this.getFilter());
        DocumentHelper.putIfNotNull(commandDocument, "sort", this.getSort());
        DocumentHelper.putIfNotNull(commandDocument, "finalize", this.getFinalizeFunction());
        DocumentHelper.putIfNotNull(commandDocument, "scope", this.getScope());
        DocumentHelper.putIfTrue(commandDocument, "verbose", this.isVerbose());
        OperationReadConcernHelper.appendReadConcernToCommand(sessionContext, commandDocument);
        DocumentHelper.putIfNotZero(commandDocument, "limit", this.getLimit());
        DocumentHelper.putIfNotZero(commandDocument, "maxTimeMS", this.getMaxTime(TimeUnit.MILLISECONDS));
        DocumentHelper.putIfTrue(commandDocument, "jsMode", this.isJsMode());
        if (this.collation != null) {
            commandDocument.put("collation", this.collation.asDocument());
        }
        return commandDocument;
    }

    private QueryResult<T> createQueryResult(BsonDocument result, ConnectionDescription description) {
        return new QueryResult(this.namespace, BsonDocumentWrapperHelper.toList(result, "results"), 0L, description.getServerAddress());
    }

    private static BsonValue asValueOrNull(BsonValue value) {
        return value == null ? BsonNull.VALUE : value;
    }
}

