/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.listeners;

import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.cache.LoggerCache;
import io.github.InsiderAnh.StellarProtect.cache.PlayerCache;
import io.github.InsiderAnh.StellarProtect.data.PlayerProtect;
import io.github.InsiderAnh.StellarProtect.database.entries.players.PlayerKillLogEntry;
import io.github.InsiderAnh.StellarProtect.enums.ActionType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;

public class PlayerLogListener
implements Listener {
    private final StellarProtect plugin = StellarProtect.getInstance();

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.getKiller() == null) {
            return;
        }
        if (ActionType.KILL_ENTITY.shouldSkipLog(entity.getWorld().getName(), entity.getType().name())) {
            return;
        }
        Player killer = entity.getKiller();
        PlayerProtect playerProtect = PlayerProtect.getPlayer(killer);
        if (playerProtect == null) {
            return;
        }
        LoggerCache.addLog(new PlayerKillLogEntry(playerProtect.getPlayerId(), (Entity)entity, ActionType.KILL_ENTITY));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerDeath(PlayerDeathEvent event) {
        if (ActionType.DEATH.shouldSkipLog(event.getEntity().getWorld().getName(), event.getEntity().getType().name())) {
            return;
        }
        Player player = event.getEntity();
        PlayerProtect playerProtect = PlayerProtect.getPlayer(player);
        if (playerProtect == null) {
            return;
        }
        PlayerKillLogEntry deathEntry = new PlayerKillLogEntry(playerProtect.getPlayerId(), (Entity)event.getEntity(), ActionType.DEATH);
        LoggerCache.addLog(deathEntry);
        PlayerCache.checkPattern(deathEntry);
    }
}

