/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.listeners;

import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.cache.LoggerCache;
import io.github.InsiderAnh.StellarProtect.data.PlayerProtect;
import io.github.InsiderAnh.StellarProtect.database.entries.players.PlayerSignChangeEntry;
import io.github.InsiderAnh.StellarProtect.enums.ActionType;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;

public class SignListener
implements Listener {
    private final StellarProtect plugin = StellarProtect.getInstance();

    @EventHandler
    public void onSign(SignChangeEvent event) {
        Player player = event.getPlayer();
        if (ActionType.SIGN_CHANGE.shouldSkipLog(player.getWorld().getName(), "SIGN")) {
            return;
        }
        PlayerProtect playerProtect = PlayerProtect.getPlayer(player);
        if (playerProtect == null) {
            return;
        }
        Block block = event.getBlock();
        LoggerCache.addLog(new PlayerSignChangeEntry(playerProtect.getPlayerId(), block, ActionType.SIGN_CHANGE));
    }
}

