/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.managers;

import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.cache.LoggerCache;
import io.github.InsiderAnh.StellarProtect.enums.ActionCategory;
import io.github.InsiderAnh.StellarProtect.hooks.tasks.TaskCanceller;

public class CacheManager {
    private final StellarProtect plugin = StellarProtect.getInstance();
    private TaskCanceller saveTask;
    private TaskCanceller deleteOldTask;
    private TaskCanceller saveItemTask;

    public void load() {
        if (this.saveTask != null) {
            this.saveTask.cancel();
        }
        if (this.deleteOldTask != null) {
            this.deleteOldTask.cancel();
        }
        if (this.saveItemTask != null) {
            this.saveItemTask.cancel();
        }
        this.saveTask = this.plugin.getStellarTaskHook(() -> {
            this.plugin.getProtectDatabase().save(LoggerCache.getFlushLogsToDatabase());
            LoggerCache.clearRamCache();
        }).runTaskTimerAsynchronously((long)this.plugin.getConfigManager().getSavePeriod() * 20L, (long)this.plugin.getConfigManager().getSavePeriod() * 20L);
        this.deleteOldTask = this.plugin.getStellarTaskHook(() -> {
            this.plugin.getProtectDatabase().clearOldLogs();
            this.plugin.getChestTransactionTracker().cleanupOldStates();
        }).runTaskTimerAsynchronously((long)this.plugin.getConfigManager().getDeleteOldPeriod() * 20L, (long)this.plugin.getConfigManager().getDeleteOldPeriod() * 20L);
        this.saveItemTask = this.plugin.getStellarTaskHook(() -> this.plugin.getItemsManager().saveItems()).runTaskTimerAsynchronously((long)this.plugin.getConfigManager().getSaveItemPeriod() * 20L, (long)this.plugin.getConfigManager().getSaveItemPeriod() * 20L);
    }

    public void forceSave(ActionCategory actionCategory) {
        this.plugin.getProtectDatabase().save(LoggerCache.getFlushLogsToDatabase(actionCategory));
    }
}

