/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.managers;

import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.items.ItemReference;
import io.github.InsiderAnh.StellarProtect.items.ItemTemplate;
import io.github.InsiderAnh.StellarProtect.utils.InventorySerializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import lombok.NonNull;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ItemsManager {
    private final ConcurrentHashMap<String, Long> itemHashToId = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, ItemTemplate> idToTemplate = new ConcurrentHashMap();
    private final HashSet<Long> unsavedTemplates = new HashSet();
    private final StellarProtect plugin = StellarProtect.getInstance();
    private final AtomicLong currentId = new AtomicLong(0L);

    public void loadItemReference(ItemTemplate template, String fullBase64) {
        this.itemHashToId.put(fullBase64, template.getId());
        this.idToTemplate.put(template.getId(), template);
    }

    @NonNull
    public ItemReference getItemReference(ItemStack itemStack) {
        return this.getItemReference(itemStack, itemStack.getAmount());
    }

    @NonNull
    public ItemReference getItemReference(ItemStack itemStack, int amount) {
        if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) {
            return new ItemReference(-1L, 1);
        }
        ItemStack reduced = itemStack.clone();
        reduced.setAmount(1);
        String base64 = InventorySerializable.itemStackToBase64(reduced).replace("\n", "").replace("\r", "");
        Long templateId = this.itemHashToId.get(base64);
        if (templateId != null) {
            return new ItemReference(templateId, amount);
        }
        templateId = this.createItemTemplate(itemStack, base64);
        return new ItemReference(templateId, amount);
    }

    public ItemTemplate getItemTemplate(long id) {
        return this.idToTemplate.get(id);
    }

    public long createItemTemplate(ItemStack itemStack, String base64) {
        long id = this.currentId.getAndIncrement();
        ItemTemplate template = new ItemTemplate(id, itemStack, base64);
        this.unsavedTemplates.add(id);
        this.idToTemplate.put(id, template);
        this.itemHashToId.put(base64, id);
        return id;
    }

    public void saveItems() {
        if (this.unsavedTemplates.isEmpty()) {
            return;
        }
        ArrayList<ItemTemplate> templates = new ArrayList<ItemTemplate>();
        this.unsavedTemplates.forEach(id -> templates.add(this.idToTemplate.get(id)));
        this.unsavedTemplates.clear();
        this.plugin.getProtectDatabase().saveItems(templates);
    }

    public long getItemReferenceCount() {
        return this.idToTemplate.size();
    }

    @Generated
    public ConcurrentHashMap<String, Long> getItemHashToId() {
        return this.itemHashToId;
    }

    @Generated
    public ConcurrentHashMap<Long, ItemTemplate> getIdToTemplate() {
        return this.idToTemplate;
    }

    @Generated
    public HashSet<Long> getUnsavedTemplates() {
        return this.unsavedTemplates;
    }

    @Generated
    public StellarProtect getPlugin() {
        return this.plugin;
    }

    @Generated
    public AtomicLong getCurrentId() {
        return this.currentId;
    }
}

