/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.data;

import io.github.insideranh.stellarprotect.arguments.RadiusArg;
import io.github.insideranh.stellarprotect.arguments.TimeArg;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.bukkit.entity.Player;

public class RestoreSession {
    private final Player player;
    private final TimeArg timeArg;
    private final RadiusArg radiusArg;
    private final List<Integer> actionTypes;
    private final HashMap<Integer, Object> processedLogHashes;
    private final HashMap<Integer, Object> restoredLogHashes;
    private final int logsPerPage;
    private int currentOffset;
    private boolean verbose;
    private boolean silent;

    public RestoreSession(Player player, TimeArg timeArg, RadiusArg radiusArg, List<Integer> actionTypes, boolean verbose, boolean silent) {
        this.player = player;
        this.timeArg = timeArg;
        this.radiusArg = radiusArg;
        this.actionTypes = actionTypes;
        this.processedLogHashes = new HashMap();
        this.restoredLogHashes = new HashMap();
        this.logsPerPage = 10;
        this.currentOffset = 0;
        this.verbose = verbose;
        this.silent = silent;
    }

    public void addProcessedLog(int logHash, Object logEntry) {
        this.processedLogHashes.put(logHash, logEntry);
    }

    public void markAsRestored(int logHash, Object logEntry) {
        this.restoredLogHashes.put(logHash, logEntry);
    }

    public void unmarkRestored(int logHash) {
        this.restoredLogHashes.remove(logHash);
    }

    public boolean isRestored(int logHash) {
        return this.restoredLogHashes.containsKey(logHash);
    }

    public boolean isProcessed(int logHash) {
        return this.processedLogHashes.containsKey(logHash);
    }

    public Object getProcessedLog(int logHash) {
        return this.processedLogHashes.get(logHash);
    }

    public Object getRestoredLog(int logHash) {
        return this.restoredLogHashes.get(logHash);
    }

    public void nextPage() {
        this.currentOffset += this.logsPerPage;
    }

    @Generated
    public Player getPlayer() {
        return this.player;
    }

    @Generated
    public TimeArg getTimeArg() {
        return this.timeArg;
    }

    @Generated
    public RadiusArg getRadiusArg() {
        return this.radiusArg;
    }

    @Generated
    public List<Integer> getActionTypes() {
        return this.actionTypes;
    }

    @Generated
    public HashMap<Integer, Object> getProcessedLogHashes() {
        return this.processedLogHashes;
    }

    @Generated
    public HashMap<Integer, Object> getRestoredLogHashes() {
        return this.restoredLogHashes;
    }

    @Generated
    public int getLogsPerPage() {
        return this.logsPerPage;
    }

    @Generated
    public int getCurrentOffset() {
        return this.currentOffset;
    }

    @Generated
    public boolean isVerbose() {
        return this.verbose;
    }

    @Generated
    public boolean isSilent() {
        return this.silent;
    }

    @Generated
    public void setCurrentOffset(int currentOffset) {
        this.currentOffset = currentOffset;
    }

    @Generated
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Generated
    public void setSilent(boolean silent) {
        this.silent = silent;
    }
}

