/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.database.entries.world;

import com.google.gson.JsonObject;
import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.database.entries.LogEntry;
import io.github.insideranh.stellarprotect.enums.ActionType;
import io.github.insideranh.stellarprotect.libs.bson.Document;
import io.github.insideranh.stellarprotect.utils.PlayerUtils;
import java.sql.ResultSet;
import lombok.Generated;
import org.bukkit.block.Block;

public class CropGrowLogEntry
extends LogEntry {
    private final int age;

    public CropGrowLogEntry(Document document, JsonObject jsonObject) {
        super(document);
        this.age = jsonObject.has("a") ? jsonObject.get("a").getAsInt() : 0;
    }

    public CropGrowLogEntry(ResultSet resultSet, JsonObject jsonObject) {
        super(resultSet);
        this.age = jsonObject.has("a") ? jsonObject.get("a").getAsInt() : 0;
    }

    public CropGrowLogEntry(long playerId, Block block) {
        super(playerId, ActionType.CROP_GROW.getId(), block.getLocation(), System.currentTimeMillis());
        this.age = StellarProtect.getInstance().getProtectNMS().getAge(block);
    }

    public CropGrowLogEntry(Block block) {
        super(PlayerUtils.getEntityByDirectId("=natural"), ActionType.CROP_GROW.getId(), block.getLocation(), System.currentTimeMillis());
        this.age = StellarProtect.getInstance().getProtectNMS().getAge(block);
    }

    @Override
    public String toSaveJson() {
        if (this.age == 0) {
            return "";
        }
        return "{\"a\":" + this.age + "}";
    }

    @Generated
    public int getAge() {
        return this.age;
    }
}

