/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.bson;

import io.github.insideranh.stellarprotect.libs.bson.BinaryVector;
import io.github.insideranh.stellarprotect.libs.bson.annotations.Beta;
import io.github.insideranh.stellarprotect.libs.bson.annotations.Reason;
import io.github.insideranh.stellarprotect.libs.bson.assertions.Assertions;
import java.util.Arrays;
import java.util.Objects;

@Beta(value={Reason.SERVER})
public final class PackedBitBinaryVector
extends BinaryVector {
    private final byte padding;
    private final byte[] data;

    PackedBitBinaryVector(byte[] data, byte padding) {
        super(BinaryVector.DataType.PACKED_BIT);
        this.data = Assertions.assertNotNull(data);
        this.padding = padding;
    }

    public byte[] getData() {
        return Assertions.assertNotNull(this.data);
    }

    public byte getPadding() {
        return this.padding;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackedBitBinaryVector that = (PackedBitBinaryVector)o;
        return this.padding == that.padding && Arrays.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.padding, Arrays.hashCode(this.data));
    }

    public String toString() {
        return "PackedBitVector{padding=" + this.padding + ", data=" + Arrays.toString(this.data) + ", dataType=" + (Object)((Object)this.getDataType()) + '}';
    }
}

