/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.bson.codecs;

import io.github.insideranh.stellarprotect.libs.bson.BsonReader;
import io.github.insideranh.stellarprotect.libs.bson.BsonWriter;
import io.github.insideranh.stellarprotect.libs.bson.codecs.Codec;
import io.github.insideranh.stellarprotect.libs.bson.codecs.DecoderContext;
import io.github.insideranh.stellarprotect.libs.bson.codecs.EncoderContext;
import io.github.insideranh.stellarprotect.libs.bson.json.JsonObject;
import io.github.insideranh.stellarprotect.libs.bson.json.JsonReader;
import io.github.insideranh.stellarprotect.libs.bson.json.JsonWriter;
import io.github.insideranh.stellarprotect.libs.bson.json.JsonWriterSettings;
import java.io.StringWriter;

public class JsonObjectCodec
implements Codec<JsonObject> {
    private final JsonWriterSettings writerSettings;

    public JsonObjectCodec() {
        this(JsonWriterSettings.builder().build());
    }

    public JsonObjectCodec(JsonWriterSettings writerSettings) {
        this.writerSettings = writerSettings;
    }

    @Override
    public void encode(BsonWriter writer, JsonObject value, EncoderContext encoderContext) {
        writer.pipe(new JsonReader(value.getJson()));
    }

    @Override
    public JsonObject decode(BsonReader reader, DecoderContext decoderContext) {
        StringWriter stringWriter = new StringWriter();
        new JsonWriter(stringWriter, this.writerSettings).pipe(reader);
        return new JsonObject(stringWriter.toString());
    }

    @Override
    public Class<JsonObject> getEncoderClass() {
        return JsonObject.class;
    }
}

