/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.bson.codecs;

import io.github.insideranh.stellarprotect.libs.bson.BsonBinary;
import io.github.insideranh.stellarprotect.libs.bson.BsonBinarySubType;
import io.github.insideranh.stellarprotect.libs.bson.BsonInvalidOperationException;
import io.github.insideranh.stellarprotect.libs.bson.BsonReader;
import io.github.insideranh.stellarprotect.libs.bson.BsonWriter;
import io.github.insideranh.stellarprotect.libs.bson.PackedBitBinaryVector;
import io.github.insideranh.stellarprotect.libs.bson.codecs.Codec;
import io.github.insideranh.stellarprotect.libs.bson.codecs.DecoderContext;
import io.github.insideranh.stellarprotect.libs.bson.codecs.EncoderContext;

final class PackedBitBinaryVectorCodec
implements Codec<PackedBitBinaryVector> {
    PackedBitBinaryVectorCodec() {
    }

    @Override
    public void encode(BsonWriter writer, PackedBitBinaryVector vectorToEncode, EncoderContext encoderContext) {
        writer.writeBinaryData(new BsonBinary(vectorToEncode));
    }

    @Override
    public PackedBitBinaryVector decode(BsonReader reader, DecoderContext decoderContext) {
        byte subType = reader.peekBinarySubType();
        if (subType != BsonBinarySubType.VECTOR.getValue()) {
            throw new BsonInvalidOperationException("Expected vector binary subtype " + BsonBinarySubType.VECTOR.getValue() + " but found: " + subType);
        }
        return reader.readBinaryData().asBinary().asVector().asPackedBitVector();
    }

    @Override
    public Class<PackedBitBinaryVector> getEncoderClass() {
        return PackedBitBinaryVector.class;
    }
}

