/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.jol.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;

public class IOUtils {
    private IOUtils() {
    }

    public static void safelyClose(OutputStream out) {
        if (out != null) {
            try {
                out.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void safelyClose(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void safelyClose(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static byte[] readAllBytes(InputStream is) {
        try {
            int read;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((read = is.read(buf)) != -1) {
                baos.write(buf, 0, read);
            }
            baos.flush();
            return baos.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }
}

