/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.client.internal;

import io.github.insideranh.stellarprotect.libs.bson.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.ReadConcern;
import io.github.insideranh.stellarprotect.libs.mongodb.ReadPreference;
import io.github.insideranh.stellarprotect.libs.mongodb.client.ClientSession;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ClusterType;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ServerDescription;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.AbstractReferenceCounted;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.ClusterAwareReadWriteBinding;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.ConnectionSource;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.ReadWriteBinding;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.TransactionContext;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.Connection;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.OperationContext;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.session.ClientSessionContext;
import java.util.function.Supplier;

public class ClientSessionBinding
extends AbstractReferenceCounted
implements ReadWriteBinding {
    private final ClusterAwareReadWriteBinding wrapped;
    private final ClientSession session;
    private final boolean ownsSession;
    private final OperationContext operationContext;

    public ClientSessionBinding(ClientSession session, boolean ownsSession, ClusterAwareReadWriteBinding wrapped) {
        this.wrapped = wrapped;
        wrapped.retain();
        this.session = Assertions.notNull("session", session);
        this.ownsSession = ownsSession;
        this.operationContext = wrapped.getOperationContext().withSessionContext(new SyncClientSessionContext(session));
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    @Override
    public int getCount() {
        return this.wrapped.getCount();
    }

    @Override
    public ClientSessionBinding retain() {
        super.retain();
        return this;
    }

    @Override
    public int release() {
        int count = super.release();
        if (count == 0) {
            this.wrapped.release();
            if (this.ownsSession) {
                this.session.close();
            }
        }
        return count;
    }

    @Override
    public ConnectionSource getReadConnectionSource() {
        return new SessionBindingConnectionSource(this.getConnectionSource(this.wrapped::getReadConnectionSource));
    }

    @Override
    public ConnectionSource getReadConnectionSource(int minWireVersion, ReadPreference fallbackReadPreference) {
        return new SessionBindingConnectionSource(this.getConnectionSource(() -> this.wrapped.getReadConnectionSource(minWireVersion, fallbackReadPreference)));
    }

    @Override
    public ConnectionSource getWriteConnectionSource() {
        return new SessionBindingConnectionSource(this.getConnectionSource(this.wrapped::getWriteConnectionSource));
    }

    @Override
    public OperationContext getOperationContext() {
        return this.operationContext;
    }

    private ConnectionSource getConnectionSource(Supplier<ConnectionSource> wrappedConnectionSourceSupplier) {
        if (!this.session.hasActiveTransaction()) {
            return wrappedConnectionSourceSupplier.get();
        }
        if (TransactionContext.get(this.session) == null) {
            ConnectionSource source = wrappedConnectionSourceSupplier.get();
            ClusterType clusterType = source.getServerDescription().getClusterType();
            if (clusterType == ClusterType.SHARDED || clusterType == ClusterType.LOAD_BALANCED) {
                TransactionContext transactionContext = new TransactionContext(clusterType);
                this.session.setTransactionContext(source.getServerDescription().getAddress(), transactionContext);
                transactionContext.release();
            }
            return source;
        }
        return this.wrapped.getConnectionSource(Assertions.assertNotNull(this.session.getPinnedServerAddress()));
    }

    private final class SyncClientSessionContext
    extends ClientSessionContext {
        private final ClientSession clientSession;

        SyncClientSessionContext(ClientSession clientSession) {
            super(clientSession);
            this.clientSession = clientSession;
        }

        @Override
        public boolean isImplicitSession() {
            return ClientSessionBinding.this.ownsSession;
        }

        @Override
        public boolean notifyMessageSent() {
            return this.clientSession.notifyMessageSent();
        }

        @Override
        public boolean hasActiveTransaction() {
            return this.clientSession.hasActiveTransaction();
        }

        @Override
        public ReadConcern getReadConcern() {
            if (this.clientSession.hasActiveTransaction()) {
                return Assertions.assertNotNull(this.clientSession.getTransactionOptions().getReadConcern());
            }
            if (this.isSnapshot()) {
                return ReadConcern.SNAPSHOT;
            }
            return ClientSessionBinding.this.wrapped.getOperationContext().getSessionContext().getReadConcern();
        }
    }

    private class SessionBindingConnectionSource
    implements ConnectionSource {
        private ConnectionSource wrapped;

        SessionBindingConnectionSource(ConnectionSource wrapped) {
            this.wrapped = wrapped;
            ClientSessionBinding.this.retain();
        }

        @Override
        public ServerDescription getServerDescription() {
            return this.wrapped.getServerDescription();
        }

        @Override
        public OperationContext getOperationContext() {
            return ClientSessionBinding.this.operationContext;
        }

        @Override
        public ReadPreference getReadPreference() {
            return this.wrapped.getReadPreference();
        }

        @Override
        public Connection getConnection() {
            Connection transactionContext = TransactionContext.get(ClientSessionBinding.this.session);
            if (transactionContext != null && ((TransactionContext)((Object)transactionContext)).isConnectionPinningRequired()) {
                Connection pinnedConnection = (Connection)((TransactionContext)((Object)transactionContext)).getPinnedConnection();
                if (pinnedConnection == null) {
                    Connection connection = this.wrapped.getConnection();
                    ((TransactionContext)((Object)transactionContext)).pinConnection((Connection)connection, Connection::markAsPinned);
                    return connection;
                }
                return pinnedConnection.retain();
            }
            return this.wrapped.getConnection();
        }

        @Override
        public ConnectionSource retain() {
            this.wrapped = this.wrapped.retain();
            return this;
        }

        @Override
        public int getCount() {
            return this.wrapped.getCount();
        }

        @Override
        public int release() {
            int count = this.wrapped.release();
            if (count == 0) {
                ClientSessionBinding.this.release();
            }
            return count;
        }
    }
}

