/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.connection;

import io.github.insideranh.stellarprotect.libs.mongodb.Block;
import io.github.insideranh.stellarprotect.libs.mongodb.ConnectionString;
import io.github.insideranh.stellarprotect.libs.mongodb.annotations.Immutable;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ProxySettings;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@Immutable
public final class SocketSettings {
    private final int connectTimeoutMS;
    private final int readTimeoutMS;
    private final int receiveBufferSize;
    private final int sendBufferSize;
    private final ProxySettings proxySettings;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SocketSettings socketSettings) {
        return SocketSettings.builder().applySettings(socketSettings);
    }

    public int getConnectTimeout(TimeUnit timeUnit) {
        return (int)timeUnit.convert(this.connectTimeoutMS, TimeUnit.MILLISECONDS);
    }

    public int getReadTimeout(TimeUnit timeUnit) {
        return (int)timeUnit.convert(this.readTimeoutMS, TimeUnit.MILLISECONDS);
    }

    public ProxySettings getProxySettings() {
        return this.proxySettings;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SocketSettings that = (SocketSettings)o;
        if (this.connectTimeoutMS != that.connectTimeoutMS) {
            return false;
        }
        if (this.readTimeoutMS != that.readTimeoutMS) {
            return false;
        }
        if (this.receiveBufferSize != that.receiveBufferSize) {
            return false;
        }
        if (this.sendBufferSize != that.sendBufferSize) {
            return false;
        }
        return this.proxySettings.equals(that.proxySettings);
    }

    public int hashCode() {
        return Objects.hash(this.connectTimeoutMS, this.readTimeoutMS, this.receiveBufferSize, this.sendBufferSize, this.proxySettings);
    }

    public String toString() {
        return "SocketSettings{connectTimeoutMS=" + this.connectTimeoutMS + ", readTimeoutMS=" + this.readTimeoutMS + ", receiveBufferSize=" + this.receiveBufferSize + ", proxySettings=" + this.proxySettings + '}';
    }

    private SocketSettings(Builder builder) {
        this.connectTimeoutMS = builder.connectTimeoutMS;
        this.readTimeoutMS = builder.readTimeoutMS;
        this.receiveBufferSize = builder.receiveBufferSize;
        this.sendBufferSize = builder.sendBufferSize;
        this.proxySettings = builder.proxySettingsBuilder.build();
    }

    private static int timeoutArgumentToMillis(long timeout, TimeUnit timeUnit) throws IllegalArgumentException {
        try {
            return Math.toIntExact(TimeUnit.MILLISECONDS.convert(timeout, timeUnit));
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException("The timeout converted to milliseconds must not be greater than `Integer.MAX_VALUE`", e);
        }
    }

    public static final class Builder {
        private int connectTimeoutMS = 10000;
        private int readTimeoutMS;
        private int receiveBufferSize;
        private int sendBufferSize;
        private ProxySettings.Builder proxySettingsBuilder = ProxySettings.builder();

        private Builder() {
        }

        public Builder applySettings(SocketSettings socketSettings) {
            Assertions.notNull("socketSettings", socketSettings);
            this.connectTimeoutMS = socketSettings.connectTimeoutMS;
            this.readTimeoutMS = socketSettings.readTimeoutMS;
            this.receiveBufferSize = socketSettings.receiveBufferSize;
            this.sendBufferSize = socketSettings.sendBufferSize;
            this.proxySettingsBuilder.applySettings(socketSettings.getProxySettings());
            return this;
        }

        public Builder connectTimeout(long connectTimeout, TimeUnit timeUnit) {
            this.connectTimeoutMS = SocketSettings.timeoutArgumentToMillis(connectTimeout, timeUnit);
            return this;
        }

        public Builder readTimeout(long readTimeout, TimeUnit timeUnit) {
            this.readTimeoutMS = SocketSettings.timeoutArgumentToMillis(readTimeout, timeUnit);
            return this;
        }

        public Builder receiveBufferSize(int receiveBufferSize) {
            this.receiveBufferSize = receiveBufferSize;
            return this;
        }

        public Builder sendBufferSize(int sendBufferSize) {
            this.sendBufferSize = sendBufferSize;
            return this;
        }

        public Builder applyToProxySettings(Block<ProxySettings.Builder> block) {
            Assertions.notNull("block", block).apply(this.proxySettingsBuilder);
            return this;
        }

        public Builder applyConnectionString(ConnectionString connectionString) {
            Integer socketTimeout;
            Integer connectTimeout = connectionString.getConnectTimeout();
            if (connectTimeout != null) {
                this.connectTimeout(connectTimeout.intValue(), TimeUnit.MILLISECONDS);
            }
            if ((socketTimeout = connectionString.getSocketTimeout()) != null) {
                this.readTimeout(socketTimeout.intValue(), TimeUnit.MILLISECONDS);
            }
            this.proxySettingsBuilder.applyConnectionString(connectionString);
            return this;
        }

        public SocketSettings build() {
            return new SocketSettings(this);
        }
    }
}

