/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.event;

import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ConnectionId;

public final class ConnectionCheckedInEvent {
    private final ConnectionId connectionId;
    private final long operationId;

    public ConnectionCheckedInEvent(ConnectionId connectionId, long operationId) {
        this.connectionId = Assertions.notNull("connectionId", connectionId);
        this.operationId = operationId;
    }

    public ConnectionId getConnectionId() {
        return this.connectionId;
    }

    public long getOperationId() {
        return this.operationId;
    }

    public String toString() {
        return "ConnectionCheckedInEvent{connectionId=" + this.connectionId + ", server=" + this.connectionId.getServerId().getAddress() + ", clusterId=" + this.connectionId.getServerId().getClusterId() + ", operationId=" + this.operationId + '}';
    }
}

