/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.event;

import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ConnectionId;
import java.util.concurrent.TimeUnit;

public final class ConnectionReadyEvent {
    private final ConnectionId connectionId;
    private final long elapsedTimeNanos;

    public ConnectionReadyEvent(ConnectionId connectionId, long elapsedTimeNanos) {
        this.connectionId = Assertions.notNull("connectionId", connectionId);
        Assertions.isTrueArgument("elapsed time is not negative", elapsedTimeNanos >= 0L);
        this.elapsedTimeNanos = elapsedTimeNanos;
    }

    public ConnectionId getConnectionId() {
        return this.connectionId;
    }

    public long getElapsedTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.elapsedTimeNanos, TimeUnit.NANOSECONDS);
    }

    public String toString() {
        return "ConnectionReadyEvent{connectionId=" + this.connectionId + ", server=" + this.connectionId.getServerId().getAddress() + ", clusterId=" + this.connectionId.getServerId().getClusterId() + ", elapsedTimeNanos=" + this.elapsedTimeNanos + '}';
    }
}

