/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.connection;

import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.BsonString;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoClientException;
import io.github.insideranh.stellarprotect.libs.mongodb.ReadConcernLevel;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.session.SessionContext;

public final class ReadConcernHelper {
    public static BsonDocument getReadConcernDocument(SessionContext sessionContext, int maxWireVersion) {
        Assertions.notNull("sessionContext", sessionContext);
        BsonDocument readConcernDocument = new BsonDocument();
        ReadConcernLevel level = sessionContext.getReadConcern().getLevel();
        if (level != null) {
            readConcernDocument.append("level", new BsonString(level.getValue()));
        }
        Assertions.assertFalse(sessionContext.isSnapshot() && sessionContext.isCausallyConsistent());
        if (sessionContext.isSnapshot() && maxWireVersion < 13) {
            throw new MongoClientException("Snapshot reads require MongoDB 5.0 or later");
        }
        if (ReadConcernHelper.shouldAddAfterClusterTime(sessionContext)) {
            readConcernDocument.append("afterClusterTime", sessionContext.getOperationTime());
        } else if (ReadConcernHelper.shouldAddAtClusterTime(sessionContext)) {
            readConcernDocument.append("atClusterTime", sessionContext.getSnapshotTimestamp());
        }
        return readConcernDocument;
    }

    private static boolean shouldAddAtClusterTime(SessionContext sessionContext) {
        return sessionContext.isSnapshot() && sessionContext.getSnapshotTimestamp() != null;
    }

    private static boolean shouldAddAfterClusterTime(SessionContext sessionContext) {
        return sessionContext.isCausallyConsistent() && sessionContext.getOperationTime() != null;
    }

    private ReadConcernHelper() {
    }
}

