/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.connection;

import io.github.insideranh.stellarprotect.libs.mongodb.MongoClientException;
import io.github.insideranh.stellarprotect.libs.mongodb.ServerAddress;
import io.github.insideranh.stellarprotect.libs.mongodb.UnixServerAddress;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.SocketSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.SslSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.BufferProvider;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.PowerOfTwoBufferPool;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.SocketStream;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.Stream;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.StreamFactory;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.UnixSocketChannelStream;
import io.github.insideranh.stellarprotect.libs.mongodb.spi.dns.InetAddressResolver;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;

public class SocketStreamFactory
implements StreamFactory {
    private final InetAddressResolver inetAddressResolver;
    private final SocketSettings settings;
    private final SslSettings sslSettings;
    private final BufferProvider bufferProvider = PowerOfTwoBufferPool.DEFAULT;

    public SocketStreamFactory(InetAddressResolver inetAddressResolver, SocketSettings settings, SslSettings sslSettings) {
        this.inetAddressResolver = inetAddressResolver;
        this.settings = Assertions.notNull("settings", settings);
        this.sslSettings = Assertions.notNull("sslSettings", sslSettings);
    }

    @Override
    public Stream create(ServerAddress serverAddress) {
        SocketStream stream;
        if (serverAddress instanceof UnixServerAddress) {
            if (this.sslSettings.isEnabled()) {
                throw new MongoClientException("Socket based connections do not support ssl");
            }
            stream = new UnixSocketChannelStream((UnixServerAddress)serverAddress, this.settings, this.sslSettings, this.bufferProvider);
        } else {
            stream = this.sslSettings.isEnabled() ? new SocketStream(serverAddress, this.inetAddressResolver, this.settings, this.sslSettings, this.getSslContext().getSocketFactory(), this.bufferProvider) : new SocketStream(serverAddress, this.inetAddressResolver, this.settings, this.sslSettings, SocketFactory.getDefault(), this.bufferProvider);
        }
        return stream;
    }

    private SSLContext getSslContext() {
        try {
            return Optional.ofNullable(this.sslSettings.getContext()).orElse(SSLContext.getDefault());
        }
        catch (NoSuchAlgorithmException e) {
            throw new MongoClientException("Unable to create default SSLContext", e);
        }
    }
}

