/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.connection;

import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoCommandException;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.TopologyVersion;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.util.Optional;

final class TopologyVersionHelper {
    static boolean newer(@Nullable TopologyVersion current, @Nullable TopologyVersion candidate) {
        return TopologyVersionHelper.compare(current, candidate) > 0;
    }

    static boolean newerOrEqual(@Nullable TopologyVersion current, @Nullable TopologyVersion candidate) {
        return TopologyVersionHelper.compare(current, candidate) >= 0;
    }

    static Optional<TopologyVersion> topologyVersion(@Nullable Throwable t) {
        BsonDocument rawTopologyVersion;
        TopologyVersion result = null;
        if (t instanceof MongoCommandException && (rawTopologyVersion = ((MongoCommandException)t).getResponse().getDocument("topologyVersion", null)) != null) {
            result = new TopologyVersion(rawTopologyVersion);
        }
        return Optional.ofNullable(result);
    }

    private static int compare(@Nullable TopologyVersion o1, @Nullable TopologyVersion o2) {
        if (o1 == null || o2 == null) {
            return -1;
        }
        if (o1.getProcessId().equals(o2.getProcessId())) {
            return Long.compare(o1.getCounter(), o2.getCounter());
        }
        return -1;
    }

    private TopologyVersionHelper() {
        throw new AssertionError();
    }
}

