/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.managers;

import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.blocks.BlockTemplate;
import io.github.insideranh.stellarprotect.blocks.DataBlock;
import io.github.insideranh.stellarprotect.maps.IntObjectMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;

public class BlocksManager {
    private final StellarProtect plugin = StellarProtect.getInstance();
    private final IntObjectMap<Integer> blockHashToId = new IntObjectMap(1000);
    private final Map<Integer, BlockTemplate> idToBlockTemplate = new HashMap<Integer, BlockTemplate>(100);
    private final Set<Integer> unsavedBlocks = new HashSet<Integer>();
    private final AtomicInteger currentId = new AtomicInteger(0);

    public void load() {
    }

    public BlockTemplate getBlockTemplate(int id) {
        return this.idToBlockTemplate.get(id);
    }

    public void loadBlockData(int id, String blockDataString) {
        DataBlock dataBlock = this.plugin.getDataBlock(blockDataString);
        BlockTemplate template = new BlockTemplate(id, dataBlock);
        this.blockHashToId.put(dataBlock.hashCode(), template.getId());
        this.idToBlockTemplate.put(template.getId(), template);
    }

    public BlockTemplate getBlockTemplate(String blockDataString) {
        DataBlock dataBlock = this.plugin.getDataBlock(blockDataString);
        int hashCode = dataBlock.hashCode();
        Integer id = this.blockHashToId.get(hashCode);
        if (id != null) {
            return this.idToBlockTemplate.get(id);
        }
        return this.createBlockTemplate(dataBlock, hashCode);
    }

    public BlockTemplate getBlockTemplate(BlockState block) {
        int hashCode = this.plugin.getProtectNMS().getHashBlockState(block);
        Integer id = this.blockHashToId.get(hashCode);
        if (id != null) {
            return this.idToBlockTemplate.get(id);
        }
        DataBlock dataBlock = this.plugin.getDataBlock(block);
        return this.createBlockTemplate(dataBlock, hashCode);
    }

    public BlockTemplate getBlockTemplate(Block block) {
        int hashCode = this.plugin.getProtectNMS().getHashBlockData(block);
        Integer id = this.blockHashToId.get(hashCode);
        if (id != null) {
            return this.idToBlockTemplate.get(id);
        }
        DataBlock dataBlock = this.plugin.getDataBlock(block);
        return this.createBlockTemplate(dataBlock, hashCode);
    }

    public BlockTemplate createBlockTemplate(DataBlock dataBlock, int hashCode) {
        int id = this.currentId.getAndIncrement();
        BlockTemplate template = new BlockTemplate(id, dataBlock);
        this.unsavedBlocks.add(id);
        this.blockHashToId.put(hashCode, id);
        this.idToBlockTemplate.put(id, template);
        return template;
    }

    public void saveBlocks() {
        if (this.unsavedBlocks.isEmpty()) {
            return;
        }
        ArrayList<BlockTemplate> templates = new ArrayList<BlockTemplate>();
        this.unsavedBlocks.forEach(id -> templates.add(this.idToBlockTemplate.get(id)));
        this.unsavedBlocks.clear();
        this.plugin.getProtectDatabase().saveBlocks(templates);
    }

    public int getBlockDataCount() {
        return this.blockHashToId.size();
    }

    @Generated
    public StellarProtect getPlugin() {
        return this.plugin;
    }

    @Generated
    public IntObjectMap<Integer> getBlockHashToId() {
        return this.blockHashToId;
    }

    @Generated
    public Map<Integer, BlockTemplate> getIdToBlockTemplate() {
        return this.idToBlockTemplate;
    }

    @Generated
    public Set<Integer> getUnsavedBlocks() {
        return this.unsavedBlocks;
    }

    @Generated
    public AtomicInteger getCurrentId() {
        return this.currentId;
    }
}

