/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.managers;

import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.cache.ItemsCache;
import io.github.insideranh.stellarprotect.items.ItemReference;
import io.github.insideranh.stellarprotect.items.ItemTemplate;
import io.github.insideranh.stellarprotect.utils.InventorySerializable;
import io.github.insideranh.stellarprotect.utils.StringCleanerUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import lombok.NonNull;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public class ItemsManager {
    private final ConcurrentHashMap<String, Long> itemHashToId = new ConcurrentHashMap(1000);
    private final ItemsCache itemCache = new ItemsCache();
    private final HashSet<Long> unsavedTemplates = new HashSet();
    private final StellarProtect plugin = StellarProtect.getInstance();
    private final AtomicLong currentId = new AtomicLong(0L);

    public void load() {
        File file;
        String selectedLang = this.plugin.getConfigManager().getItemsLang();
        if (selectedLang.equalsIgnoreCase("en")) {
            StringCleanerUtils.setHasTranslation(false);
            return;
        }
        if (selectedLang.equalsIgnoreCase("zh")) {
            selectedLang = "zh_cn";
            this.plugin.getLogger().info("Legacy 'zh' language detected, using 'zh_cn' (Simplified Chinese) instead. Consider updating your config to use 'zh_cn' or 'zh_tw' explicitly.");
        }
        this.plugin.getLogger().info("Loading items translations...");
        File folder = new File(this.plugin.getDataFolder(), "translations");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (!(file = new File(folder, "items_" + selectedLang + ".yml")).exists()) {
            try {
                this.plugin.saveResource("translations/items_" + selectedLang + ".yml", false);
                this.plugin.getLogger().info("Saved default items translations file for " + selectedLang + ".");
            }
            catch (Exception exception) {
                this.plugin.getLogger().info("The translation file for " + selectedLang + " does not exist. Using default en, if you need a translation, please contact InsiderAnh on Discord.");
                return;
            }
        }
        StringCleanerUtils.setHasTranslation(true);
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        Set keys = config.getKeys(false);
        for (String key : keys) {
            StringCleanerUtils.addMaterialTranslation(key.toUpperCase(), config.getString(key));
        }
        this.plugin.getLogger().info("Loaded " + keys.size() + " items translations for " + selectedLang + ".");
    }

    public void loadItemReference(ItemTemplate template, String fullBase64) {
        this.itemHashToId.put(fullBase64, template.getId());
        this.itemCache.put(template);
    }

    @NonNull
    public ItemReference getItemReference(ItemStack itemStack) {
        return this.getItemReference(itemStack, itemStack.getAmount());
    }

    @NonNull
    public ItemReference getItemReference(ItemStack itemStack, int amount) {
        if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) {
            return new ItemReference(-1L, 1);
        }
        ItemStack reduced = itemStack.clone();
        reduced.setAmount(1);
        String base64 = InventorySerializable.itemStackToBase64(reduced).replace("\n", "").replace("\r", "");
        Long templateId = this.itemHashToId.get(base64);
        if (templateId != null) {
            return new ItemReference(templateId, amount);
        }
        templateId = this.createItemTemplate(itemStack, base64);
        return new ItemReference(templateId, amount);
    }

    public ItemTemplate getItemTemplate(long id) {
        return this.itemCache.getById(id);
    }

    public long createItemTemplate(ItemStack itemStack, String base64) {
        long id = this.currentId.getAndIncrement();
        ItemTemplate template = new ItemTemplate(id, itemStack, base64);
        this.unsavedTemplates.add(id);
        this.itemCache.put(template);
        this.itemHashToId.put(base64, id);
        return id;
    }

    public void saveItems() {
        if (this.unsavedTemplates.isEmpty()) {
            return;
        }
        ArrayList<ItemTemplate> templates = new ArrayList<ItemTemplate>();
        this.unsavedTemplates.forEach(id -> templates.add(this.itemCache.getById((long)id)));
        this.unsavedTemplates.clear();
        this.plugin.getProtectDatabase().saveItems(templates);
    }

    public long getItemReferenceCount() {
        return this.itemCache.size();
    }

    @Generated
    public ConcurrentHashMap<String, Long> getItemHashToId() {
        return this.itemHashToId;
    }

    @Generated
    public ItemsCache getItemCache() {
        return this.itemCache;
    }

    @Generated
    public HashSet<Long> getUnsavedTemplates() {
        return this.unsavedTemplates;
    }

    @Generated
    public StellarProtect getPlugin() {
        return this.plugin;
    }

    @Generated
    public AtomicLong getCurrentId() {
        return this.currentId;
    }
}

