/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.commands.arguments;

import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.arguments.ArgumentsParser;
import io.github.InsiderAnh.StellarProtect.arguments.RadiusArg;
import io.github.InsiderAnh.StellarProtect.arguments.TimeArg;
import io.github.InsiderAnh.StellarProtect.commands.StellarArgument;
import io.github.InsiderAnh.StellarProtect.data.PlayerProtect;
import io.github.InsiderAnh.StellarProtect.enums.ActionType;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PurgeArgument
extends StellarArgument {
    private final StellarProtect plugin = StellarProtect.getInstance();

    @Override
    public void onCommand(@NotNull CommandSender sender, String[] arguments) {
        if (!(sender instanceof Player)) {
            this.plugin.getLangManager().sendMessage(sender, "messages.onlyPlayer");
            return;
        }
        Player player = (Player)sender;
        PlayerProtect playerProtect = PlayerProtect.getPlayer(player);
        if (playerProtect == null) {
            return;
        }
        TimeArg timeArg = ArgumentsParser.parseTime(arguments);
        RadiusArg radiusArg = ArgumentsParser.parseRadiusOrNull(arguments, player.getLocation());
        ActionType actionTypeArg = ArgumentsParser.parseActionType(arguments);
        this.plugin.getProtectDatabase().purgeLogs(timeArg, radiusArg, actionTypeArg);
        this.plugin.getLangManager().sendMessage(sender, "messages.purged");
    }

    @Override
    public List<String> onTabComplete(@NotNull CommandSender sender, String[] arguments) {
        if (arguments.length >= 1) {
            String currentArg = arguments[arguments.length - 1];
            if (currentArg.startsWith("a:") || currentArg.startsWith("action:")) {
                return ActionType.getAllNames(currentArg.replaceFirst("a:", "").replaceFirst("action:", "").toLowerCase());
            }
            if (currentArg.startsWith("t:") || currentArg.startsWith("time:")) {
                return Arrays.asList("t:1h", "t:1d", "t:1w", "t:1mo");
            }
            if (currentArg.startsWith("r:") || currentArg.startsWith("radius:")) {
                return Arrays.asList("r:10", "r:20", "r:30", "r:40", "r:50");
            }
        }
        return Arrays.asList("t:1h", "r:10", "p:1-10", "a:block_break");
    }
}

