/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.database.types;

import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.database.repositories.DatabaseConnection;
import io.github.InsiderAnh.StellarProtect.database.repositories.IdsRepository;
import io.github.InsiderAnh.StellarProtect.database.repositories.ItemsRepository;
import io.github.InsiderAnh.StellarProtect.database.repositories.LoggerRepository;
import io.github.InsiderAnh.StellarProtect.database.repositories.PlayerRepository;
import io.github.InsiderAnh.StellarProtect.database.repositories.RestoreRepository;
import io.github.InsiderAnh.StellarProtect.database.types.mysql.IdsRepositoryMySQL;
import io.github.InsiderAnh.StellarProtect.database.types.mysql.ItemsRepositoryMySQL;
import io.github.InsiderAnh.StellarProtect.database.types.mysql.LoggerRepositoryMySQL;
import io.github.InsiderAnh.StellarProtect.database.types.mysql.PlayerRepositoryMySQL;
import io.github.InsiderAnh.StellarProtect.database.types.mysql.RestoreRepositoryMySQL;
import io.github.InsiderAnh.StellarProtect.libs.hikaricp.HikariConfig;
import io.github.InsiderAnh.StellarProtect.libs.hikaricp.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import lombok.Generated;

public class MySQLConnection
implements DatabaseConnection {
    private final StellarProtect stellarProtect = StellarProtect.getInstance();
    private PlayerRepository playerRepository;
    private LoggerRepository loggerRepository;
    private IdsRepository idsRepository;
    private ItemsRepository itemsRepository;
    private RestoreRepository restoreRepository;
    private HikariDataSource dataSource;

    @Override
    public void connect() {
        try {
            HikariConfig config = new HikariConfig();
            config.setJdbcUrl("jdbc:mysql://" + this.stellarProtect.getConfig().getString("databases.mysql.host") + ":" + this.stellarProtect.getConfig().getInt("databases.mysql.port") + "/" + this.stellarProtect.getConfig().getString("databases.mysql.database"));
            config.setUsername(this.stellarProtect.getConfig().getString("databases.mysql.user"));
            config.setPassword(this.stellarProtect.getConfig().getString("databases.mysql.password"));
            config.addDataSourceProperty("cachePrepStmts", "true");
            config.addDataSourceProperty("prepStmtCacheSize", "250");
            config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
            config.addDataSourceProperty("autoReconnect", "true");
            config.addDataSourceProperty("leakDetectionThreshold", "true");
            config.addDataSourceProperty("verifyServerCertificate", "false");
            config.addDataSourceProperty("useSSL", "false");
            config.setMaximumPoolSize(10);
            config.setConnectionTimeout(250L);
            config.setLeakDetectionThreshold(60000L);
            this.dataSource = new HikariDataSource(config);
            try (Connection connection = this.dataSource.getConnection();
                 Statement statement = connection.createStatement();){
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS players (id BIGINT PRIMARY KEY,uuid VARCHAR(36) NOT NULL,name VARCHAR(36))");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS worlds (id INT PRIMARY KEY,name TEXT NOT NULL)");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS entity_ids (id BIGINT PRIMARY KEY,entityType TEXT NOT NULL)");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS log_entries (id BIGINT AUTO_INCREMENT PRIMARY KEY,player_id BIGINT,world_id INT,x DECIMAL(8, 2),y DECIMAL(8, 2),z DECIMAL(8, 2),action_type INT,extra_json TEXT,created_at BIGINT,FOREIGN KEY (player_id) REFERENCES players(id),FOREIGN KEY (world_id) REFERENCES worlds(id))");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS id_counter (table_name TEXT PRIMARY KEY,current_id INTEGER)");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS item_templates (id BIGINT PRIMARY KEY,base64 TEXT,s TINYINT,access_count INTEGER DEFAULT 0,last_accessed TIMESTAMP DEFAULT CURRENT_TIMESTAMP,total_quantity_used INTEGER DEFAULT 0,created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP)");
                statement.execute("SET SESSION innodb_flush_log_at_trx_commit = 2");
                statement.execute("SET SESSION sql_log_bin = 0");
                statement.execute("SET SESSION foreign_key_checks = 0");
                statement.execute("SET SESSION unique_checks = 0");
                statement.execute("SET SESSION autocommit = 0");
            }
            this.playerRepository = new PlayerRepositoryMySQL(this.dataSource);
            this.loggerRepository = new LoggerRepositoryMySQL(this.dataSource);
            this.idsRepository = new IdsRepositoryMySQL(this.dataSource);
            this.itemsRepository = new ItemsRepositoryMySQL(this.dataSource);
            this.restoreRepository = new RestoreRepositoryMySQL(this.dataSource);
            this.stellarProtect.getLogger().info("Connected to MySQL database correctly.");
        }
        catch (Exception exception) {
            this.stellarProtect.getLogger().warning("Error on connect to MySQL database.");
        }
    }

    @Override
    public void createIndexes() {
        try (Connection connection = this.dataSource.getConnection();
             Statement stmt = connection.createStatement();){
            stmt.execute("CREATE INDEX IF NOT EXISTS idx_query_main ON log_entries (created_at, action_type, x, y, z)");
            stmt.execute("CREATE INDEX IF NOT EXISTS idx_log_entries_optimized ON log_entries (created_at DESC, action_type, x, y, z, player_id)");
            stmt.execute("CREATE INDEX IF NOT EXISTS idx_action_time_coords ON log_entries (action_type, created_at, x, y, z)");
            stmt.execute("CREATE INDEX IF NOT EXISTS idx_time_action ON log_entries (created_at, action_type)");
            stmt.execute("CREATE INDEX IF NOT EXISTS idx_player_time ON log_entries (player_id, created_at)");
            stmt.execute("CREATE INDEX IF NOT EXISTS idx_world_time ON log_entries (world_id, created_at)");
            stmt.execute("CREATE INDEX IF NOT EXISTS idx_log_entries_filtering ON log_entries (created_at, x, y, z)");
            stmt.execute("CREATE INDEX IF NOT EXISTS idx_item_hash ON item_templates(base64)");
            stmt.execute("CREATE INDEX IF NOT EXISTS idx_item_access_count ON item_templates(access_count DESC)");
            stmt.execute("CREATE INDEX IF NOT EXISTS idx_item_last_accessed ON item_templates(last_accessed DESC)");
            stmt.execute("CREATE INDEX IF NOT EXISTS idx_item_total_used ON item_templates(total_quantity_used DESC)");
        }
        catch (SQLException e) {
            this.stellarProtect.getLogger().info("Failed to create indexes");
        }
    }

    @Override
    public void close() {
        if (this.dataSource != null) {
            this.dataSource.close();
        }
    }

    @Generated
    public StellarProtect getStellarProtect() {
        return this.stellarProtect;
    }

    @Override
    @Generated
    public PlayerRepository getPlayerRepository() {
        return this.playerRepository;
    }

    @Override
    @Generated
    public LoggerRepository getLoggerRepository() {
        return this.loggerRepository;
    }

    @Override
    @Generated
    public IdsRepository getIdsRepository() {
        return this.idsRepository;
    }

    @Override
    @Generated
    public ItemsRepository getItemsRepository() {
        return this.itemsRepository;
    }

    @Override
    @Generated
    public RestoreRepository getRestoreRepository() {
        return this.restoreRepository;
    }

    @Generated
    public HikariDataSource getDataSource() {
        return this.dataSource;
    }
}

