/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.database.types.mongo;

import io.github.InsiderAnh.StellarProtect.data.PlayerProtect;
import io.github.InsiderAnh.StellarProtect.database.repositories.PlayerRepository;
import io.github.InsiderAnh.StellarProtect.libs.bson.Document;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.MongoCollection;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.MongoDatabase;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.model.Filters;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.model.FindOneAndUpdateOptions;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.model.ReturnDocument;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.model.Updates;
import org.bukkit.entity.Player;

public class PlayerRepositoryMongo
implements PlayerRepository {
    private final MongoDatabase database;
    private final MongoCollection<Document> players;

    public PlayerRepositoryMongo(MongoDatabase database) {
        this.database = database;
        this.players = database.getCollection("players");
    }

    @Override
    public PlayerProtect loadOrCreatePlayer(Player player) {
        Document doc = (Document)this.players.find(Filters.eq("uuid", player.getUniqueId().toString())).first();
        if (doc != null) {
            return new PlayerProtect(player.getUniqueId(), doc.getLong("id"));
        }
        PlayerProtect playerProtect = new PlayerProtect(player.getUniqueId(), this.generateNextId());
        Document playerDoc = new Document("uuid", player.getUniqueId().toString()).append("name", player.getName()).append("id", playerProtect.getPlayerId());
        this.players.insertOne(playerDoc);
        return playerProtect;
    }

    @Override
    public long generateNextId() {
        Document result = this.database.getCollection("counters").findOneAndUpdate(Filters.eq("_id", "players"), Updates.inc("seq", 1), new FindOneAndUpdateOptions().upsert(true).returnDocument(ReturnDocument.AFTER));
        if (result != null && result.containsKey("seq")) {
            return result.getLong("seq");
        }
        throw new NullPointerException("No se pudo generar un nuevo ID para players.");
    }
}

