/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.database.types.sql;

import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.database.repositories.IdsRepository;
import io.github.InsiderAnh.StellarProtect.utils.Debugger;
import io.github.InsiderAnh.StellarProtect.utils.PlayerUtils;
import io.github.InsiderAnh.StellarProtect.utils.WorldUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class IdsRepositorySQL
implements IdsRepository {
    private final StellarProtect stellarProtect = StellarProtect.getInstance();
    private final Connection connection;

    public IdsRepositorySQL(Connection connection) {
        this.connection = connection;
    }

    @Override
    public void loadWorlds() {
        try (PreparedStatement stmt = this.connection.prepareStatement("SELECT * FROM worlds");){
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String world = rs.getString("name");
                int id = rs.getInt("id");
                WorldUtils.cacheWorld(world, id);
                Debugger.debugExtras("Loaded world " + world + " with id " + id);
            }
        }
        catch (SQLException e) {
            this.stellarProtect.getLogger().warning("Error on loadWorlds: " + e.getMessage());
        }
    }

    @Override
    public void loadEntityIds() {
        try (PreparedStatement stmt = this.connection.prepareStatement("SELECT * FROM entity_ids");){
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String entityType = rs.getString("entityType");
                int id = rs.getInt("id");
                PlayerUtils.cacheEntityId(entityType, id);
                Debugger.debugExtras("Loaded entity " + entityType + " with id " + id);
            }
            PlayerUtils.loadEntityIds();
        }
        catch (SQLException e) {
            this.stellarProtect.getLogger().warning("Error on loadWorlds: " + e.getMessage());
        }
    }

    @Override
    public void saveWorld(String world, int id) {
        try (PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO worlds (id, name) VALUES (?, ?)");){
            stmt.setInt(1, id);
            stmt.setString(2, world);
            stmt.executeUpdate();
            Debugger.debugExtras("Saved world " + world + " with id " + id);
        }
        catch (SQLException e) {
            this.stellarProtect.getLogger().warning("Error on saveWorld: " + e.getMessage());
        }
    }

    @Override
    public void saveEntityId(String entityType, long id) {
        try (PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO entity_ids (entityType, id) VALUES (?, ?)");){
            stmt.setString(1, entityType);
            stmt.setLong(2, id);
            stmt.executeUpdate();
            Debugger.debugExtras("Saved entity " + entityType + " with id " + id);
        }
        catch (SQLException e) {
            this.stellarProtect.getLogger().warning("Error on saveEntityId: " + e.getMessage());
        }
    }
}

