/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.database.types.sql;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.arguments.RadiusArg;
import io.github.InsiderAnh.StellarProtect.arguments.TimeArg;
import io.github.InsiderAnh.StellarProtect.cache.LoggerCache;
import io.github.InsiderAnh.StellarProtect.cache.PlayerCache;
import io.github.InsiderAnh.StellarProtect.cache.keys.LocationCache;
import io.github.InsiderAnh.StellarProtect.callback.CallbackLookup;
import io.github.InsiderAnh.StellarProtect.database.entries.LogEntry;
import io.github.InsiderAnh.StellarProtect.database.entries.items.ItemLogEntry;
import io.github.InsiderAnh.StellarProtect.database.entries.players.PlayerTransactionEntry;
import io.github.InsiderAnh.StellarProtect.database.repositories.LoggerRepository;
import io.github.InsiderAnh.StellarProtect.database.types.factory.LogEntryFactory;
import io.github.InsiderAnh.StellarProtect.enums.ActionType;
import io.github.InsiderAnh.StellarProtect.items.ItemTemplate;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.lang.Nullable;
import io.github.InsiderAnh.StellarProtect.utils.Debugger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;

public class LoggerRepositorySQL
implements LoggerRepository {
    private final StellarProtect stellarProtect = StellarProtect.getInstance();
    private final Connection connection;

    public LoggerRepositorySQL(Connection connection) {
        this.connection = connection;
    }

    @Override
    public void loadTemporaryLogs() {
        Debugger.debugLog("Loading logs from database...");
        AtomicInteger count = new AtomicInteger(0);
        long twelveHoursAgo = System.currentTimeMillis() - 43200000L;
        try {
            try (PreparedStatement stmt = this.connection.prepareStatement("SELECT ple.*, p.name, p.uuid FROM log_entries ple JOIN players p ON ple.player_id = p.id WHERE ple.created_at >= ? ORDER BY ple.created_at DESC LIMIT 10000");){
                stmt.setLong(1, twelveHoursAgo);
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    long playerId = rs.getLong("player_id");
                    String playerName = rs.getString("name");
                    PlayerCache.cacheName(playerId, playerName);
                    LogEntry entry = LogEntryFactory.fromDatabase(rs);
                    LoggerCache.loadLog(entry);
                    count.incrementAndGet();
                }
            }
            Debugger.debugLog("Loaded " + count.get() + " logs from database.");
        }
        catch (Exception e) {
            this.stellarProtect.getLogger().log(Level.SEVERE, "Failed to load temporary logs.", e);
        }
    }

    @Override
    public void clearOldLogs() {
        Debugger.debugLog("Clearing old logs...");
        this.stellarProtect.getExecutor().execute(() -> {
            int daysToKeep = this.stellarProtect.getConfigManager().getDaysToKeepLogs();
            long expirationTime = System.currentTimeMillis() - (long)daysToKeep * 24L * 60L * 60L * 1000L;
            try (PreparedStatement stmt = this.connection.prepareStatement("DELETE FROM log_entries WHERE created_at <= ?");){
                stmt.setLong(1, expirationTime);
                int deleted = stmt.executeUpdate();
                if (deleted > 0) {
                    Debugger.debugLog("Cleared " + deleted + " old logs from the database.");
                } else {
                    Debugger.debugLog("No old logs found to delete.");
                }
            }
            catch (SQLException e) {
                this.stellarProtect.getLogger().log(Level.SEVERE, "Failed to clear old logs.", e);
            }
        });
    }

    @Override
    public void purgeLogs(@NonNull TimeArg timeArg, @Nullable RadiusArg radiusArg, @Nullable ActionType actionType) {
        if (timeArg == null) {
            throw new NullPointerException("timeArg is marked non-null but is null");
        }
        long start = System.currentTimeMillis();
        Debugger.debugSave("Purging logs...");
        ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1024)));
        executor.execute(() -> {
            try {
                StringBuilder sql = new StringBuilder("DELETE FROM log_entries WHERE created_at BETWEEN ? AND ?");
                if (radiusArg != null) {
                    sql.append(" AND x BETWEEN ? AND ? AND y BETWEEN ? AND ? AND z BETWEEN ? AND ?");
                }
                if (actionType != null) {
                    sql.append(" AND action_type = ?");
                }
                try (PreparedStatement stmt = this.connection.prepareStatement(sql.toString());){
                    int deleted;
                    int paramIndex = 1;
                    stmt.setLong(paramIndex++, timeArg.getStart());
                    stmt.setLong(paramIndex++, timeArg.getEnd());
                    if (radiusArg != null) {
                        stmt.setDouble(paramIndex++, radiusArg.getMinX());
                        stmt.setDouble(paramIndex++, radiusArg.getMaxX());
                        stmt.setDouble(paramIndex++, radiusArg.getMinY());
                        stmt.setDouble(paramIndex++, radiusArg.getMaxY());
                        stmt.setDouble(paramIndex++, radiusArg.getMinZ());
                        stmt.setDouble(paramIndex++, radiusArg.getMaxZ());
                    }
                    if (actionType != null) {
                        stmt.setInt(paramIndex, actionType.getId());
                    }
                    if ((deleted = stmt.executeUpdate()) > 0) {
                        Debugger.debugSave("Purged " + deleted + " logs in " + (System.currentTimeMillis() - start) + "ms");
                    } else {
                        Debugger.debugSave("No logs found to delete.");
                    }
                }
            }
            catch (SQLException e) {
                this.stellarProtect.getLogger().log(Level.SEVERE, "Failed to purge logs.", e);
            }
        });
        executor.shutdown();
    }

    @Override
    public void save(List<LogEntry> logEntries) {
        long start = System.currentTimeMillis();
        Debugger.debugSave("Saving log entries...");
        this.stellarProtect.getExecutor().execute(() -> {
            try {
                this.connection.setAutoCommit(false);
                try (PreparedStatement playerStmt = this.connection.prepareStatement("INSERT INTO log_entries (player_id, world_id, x, y, z, action_type, extra_json, created_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");){
                    for (LogEntry playerLog : logEntries) {
                        String extraJson = playerLog.toSaveJson();
                        playerStmt.setLong(1, playerLog.getPlayerId());
                        playerStmt.setInt(2, playerLog.getWorldId());
                        playerStmt.setDouble(3, playerLog.getX());
                        playerStmt.setDouble(4, playerLog.getY());
                        playerStmt.setDouble(5, playerLog.getZ());
                        playerStmt.setInt(6, playerLog.getActionType());
                        playerStmt.setString(7, extraJson);
                        playerStmt.setLong(8, playerLog.getCreatedAt());
                        playerStmt.addBatch();
                    }
                    playerStmt.executeBatch();
                    this.connection.commit();
                }
                catch (Exception e) {
                    this.connection.rollback();
                    throw e;
                }
                finally {
                    this.connection.setAutoCommit(true);
                }
            }
            catch (Exception e) {
                this.stellarProtect.getLogger().log(Level.SEVERE, "Failed to save log entries.", e);
            }
            Debugger.debugSave("Saved " + logEntries.size() + " log entries in " + (System.currentTimeMillis() - start) + "ms");
        });
    }

    @Override
    public CompletableFuture<CallbackLookup<List<ItemLogEntry>, Long>> getChestTransactions(@NonNull Location location, int skip, int limit) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        return CompletableFuture.supplyAsync(() -> {
            List cachedLogs = LoggerCache.getChestTransactions(location, 0, Integer.MAX_VALUE).stream().filter(log -> System.currentTimeMillis() - log.getCreatedAt() <= TimeUnit.MINUTES.toMillis(15L)).sorted(Comparator.comparingLong(ItemLogEntry::getCreatedAt).reversed()).collect(Collectors.toList());
            List paginatedCachedLogs = cachedLogs.stream().skip(skip).limit(limit).collect(Collectors.toList());
            LinkedList result = new LinkedList(paginatedCachedLogs);
            int remaining = limit - paginatedCachedLogs.size();
            if (remaining > 0) {
                int effectiveSkipForDB = Math.max(0, skip - cachedLogs.size());
                int processedItemFromDB = 0;
                Set cachedItemKeys = cachedLogs.stream().map(ItemLogEntry::getItemStack).filter(Objects::nonNull).map(this::createItemKey).collect(Collectors.toSet());
                int addedFromDB = 0;
                int blockStart = 0;
                int blockSize = Math.max(10, remaining);
                long totalDBLogs = 0L;
                boolean hasMoreBlocks = true;
                while (addedFromDB < remaining && hasMoreBlocks) {
                    CallbackLookup<Set<LogEntry>, Long> dbLookup = this.queryLogsFromDB(location, blockStart, blockSize, ActionType.INVENTORY_TRANSACTION);
                    List dbLogs = dbLookup.getLogs().stream().filter(PlayerTransactionEntry.class::isInstance).sorted(Comparator.comparingLong(LogEntry::getCreatedAt).reversed()).collect(Collectors.toList());
                    if (dbLogs.isEmpty()) break;
                    int itemsAddedInThisBlock = 0;
                    block1: for (LogEntry log2 : dbLogs) {
                        String itemKey;
                        ItemStack item;
                        ItemTemplate itemTemplate;
                        PlayerTransactionEntry transaction = (PlayerTransactionEntry)log2;
                        if (addedFromDB >= remaining) {
                            totalDBLogs += (long)(transaction.getAdded().size() + transaction.getRemoved().size());
                            break;
                        }
                        totalDBLogs += (long)(transaction.getAdded().size() + transaction.getRemoved().size());
                        for (Map.Entry<Long, Integer> addedEntry : transaction.getAdded().entrySet()) {
                            if (++processedItemFromDB <= effectiveSkipForDB) continue;
                            if (addedFromDB >= remaining) break;
                            itemTemplate = this.stellarProtect.getItemsManager().getItemTemplate(addedEntry.getKey());
                            item = itemTemplate.getBukkitItem();
                            if (item == null || cachedItemKeys.contains(itemKey = this.createItemKey(item))) continue;
                            result.add(new ItemLogEntry(item, log2.getPlayerId(), addedEntry.getValue(), true, log2.getCreatedAt()));
                            ++addedFromDB;
                            ++itemsAddedInThisBlock;
                        }
                        for (Map.Entry<Long, Integer> removedEntry : transaction.getRemoved().entrySet()) {
                            if (++processedItemFromDB <= effectiveSkipForDB) continue;
                            if (addedFromDB >= remaining) continue block1;
                            itemTemplate = this.stellarProtect.getItemsManager().getItemTemplate(removedEntry.getKey());
                            item = itemTemplate.getBukkitItem();
                            if (item == null || cachedItemKeys.contains(itemKey = this.createItemKey(item))) continue;
                            result.add(new ItemLogEntry(item, log2.getPlayerId(), removedEntry.getValue(), false, log2.getCreatedAt()));
                            ++addedFromDB;
                            ++itemsAddedInThisBlock;
                        }
                    }
                    if (itemsAddedInThisBlock == 0 && addedFromDB < remaining) {
                        if ((long)((blockStart += blockSize) + blockSize) < totalDBLogs) continue;
                        hasMoreBlocks = false;
                        continue;
                    }
                    if (addedFromDB < remaining && dbLogs.size() == blockSize) {
                        if ((long)(blockStart += blockSize) < totalDBLogs) continue;
                        hasMoreBlocks = false;
                        continue;
                    }
                    hasMoreBlocks = false;
                }
                long estimatedTotalCount = (long)cachedLogs.size() + totalDBLogs;
                return new CallbackLookup(result, estimatedTotalCount);
            }
            return new CallbackLookup(result, Long.valueOf(cachedLogs.size()));
        }, (Executor)this.stellarProtect.getLookupExecutor());
    }

    private String createItemKey(ItemStack item) {
        return item.getType() + ":" + item.getDurability() + ":" + (item.hasItemMeta() ? item.getItemMeta().toString() : "null");
    }

    @Override
    public CompletableFuture<CallbackLookup<Map<LocationCache, Set<LogEntry>>, Long>> getLogs(@NonNull TimeArg timeArg, @NonNull RadiusArg radiusArg, @Nullable ActionType actionType, int skip, int limit) {
        if (timeArg == null) {
            throw new NullPointerException("timeArg is marked non-null but is null");
        }
        if (radiusArg == null) {
            throw new NullPointerException("radiusArg is marked non-null but is null");
        }
        return CompletableFuture.supplyAsync(() -> {
            List cachedLogs = LoggerCache.getLogs(timeArg, radiusArg, actionType, skip, limit).stream().sorted(Comparator.comparingLong(LogEntry::getCreatedAt).reversed()).collect(Collectors.toList());
            Map groupedResults = cachedLogs.stream().collect(Collectors.groupingBy(LocationCache::of, LinkedHashMap::new, Collectors.toCollection(LinkedHashSet::new)));
            int remaining = limit - cachedLogs.size();
            if (remaining > 0) {
                int dbSkip = skip + cachedLogs.size();
                CallbackLookup<Map<LocationCache, Set<LogEntry>>, Long> dbLookup = this.queryLogsFromDB(timeArg, radiusArg, dbSkip, remaining);
                List dbLogs = dbLookup.getLogs().values().stream().flatMap(Collection::stream).filter(log -> cachedLogs.stream().noneMatch(c -> c.equals(log))).sorted(Comparator.comparingLong(LogEntry::getCreatedAt).reversed()).limit(remaining).collect(Collectors.toList());
                Map dbGrouped = dbLogs.stream().collect(Collectors.groupingBy(LocationCache::of, LinkedHashMap::new, Collectors.toCollection(LinkedHashSet::new)));
                dbGrouped.forEach((location, logs) -> groupedResults.merge(location, logs, (existing, newLogs) -> {
                    existing.addAll(newLogs);
                    return existing;
                }));
                return new CallbackLookup<Map, Long>(groupedResults, dbLookup.getTotal());
            }
            return new CallbackLookup<Map, Long>(groupedResults, (long)skip + (long)cachedLogs.size());
        }, (Executor)this.stellarProtect.getLookupExecutor());
    }

    @Override
    public CompletableFuture<CallbackLookup<Set<LogEntry>, Long>> getLogs(@NonNull Location location, int skip, int limit) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        return CompletableFuture.supplyAsync(() -> {
            List cachedLogs = LoggerCache.getLogs(LocationCache.of(location), skip, limit).stream().filter(log -> System.currentTimeMillis() - log.getCreatedAt() <= TimeUnit.MINUTES.toMillis(15L)).sorted(Comparator.comparingLong(LogEntry::getCreatedAt).reversed()).collect(Collectors.toList());
            LinkedHashSet result = new LinkedHashSet(cachedLogs);
            int remaining = limit - cachedLogs.size();
            if (remaining > 0) {
                int dbSkip = skip + cachedLogs.size();
                CallbackLookup<Set<LogEntry>, Long> dbLookup = this.queryLogsFromDB(location, dbSkip, remaining, null);
                List dbLogs = dbLookup.getLogs().stream().filter(log -> cachedLogs.stream().noneMatch(c -> c.equals(log))).sorted(Comparator.comparingLong(LogEntry::getCreatedAt).reversed()).limit(remaining).collect(Collectors.toList());
                result.addAll(dbLogs);
                return new CallbackLookup(result, dbLookup.getTotal());
            }
            return new CallbackLookup(result, (long)skip + (long)cachedLogs.size());
        }, (Executor)this.stellarProtect.getLookupExecutor());
    }

    private CallbackLookup<Set<LogEntry>, Long> queryLogsFromDB(Location location, int skip, int limit, @Nullable ActionType actionType) {
        LinkedHashSet<LogEntry> logs = new LinkedHashSet<LogEntry>();
        long totalCount = 0L;
        String actionTypeFilter = actionType != null ? "AND ple.action_type = ? " : "";
        String dataQuery = "SELECT ple.*, p.name, p.uuid FROM log_entries ple JOIN players p ON ple.player_id = p.id WHERE ple.created_at BETWEEN ? AND ? AND ple.x = ? AND ple.y = ? AND ple.z = ? " + actionTypeFilter + "ORDER BY ple.created_at DESC LIMIT ? OFFSET ?";
        String countQuery = "SELECT COUNT(*) FROM log_entries WHERE created_at BETWEEN ? AND ? AND x = ? AND y = ? AND z = ?";
        long startTime = System.currentTimeMillis() - TimeUnit.DAYS.toMillis(30L);
        long endTime = System.currentTimeMillis();
        try (PreparedStatement countStmt = this.connection.prepareStatement(countQuery);){
            countStmt.setLong(1, startTime);
            countStmt.setLong(2, endTime);
            countStmt.setDouble(3, location.getBlockX());
            countStmt.setDouble(4, location.getBlockY());
            countStmt.setDouble(5, location.getBlockZ());
            try (ResultSet resultSet = countStmt.executeQuery();){
                if (resultSet.next()) {
                    totalCount = resultSet.getLong(1);
                }
            }
        }
        catch (SQLException e) {
            this.stellarProtect.getLogger().log(Level.SEVERE, "Error in count", e);
        }
        try (PreparedStatement dataStmt = this.connection.prepareStatement(dataQuery);){
            dataStmt.setLong(1, startTime);
            dataStmt.setLong(2, endTime);
            dataStmt.setDouble(3, location.getBlockX());
            dataStmt.setDouble(4, location.getBlockY());
            dataStmt.setDouble(5, location.getBlockZ());
            if (actionType != null) {
                dataStmt.setInt(6, actionType.getId());
                dataStmt.setInt(7, limit);
                dataStmt.setInt(8, skip);
            } else {
                dataStmt.setInt(6, limit);
                dataStmt.setInt(7, skip);
            }
            try (ResultSet rs = dataStmt.executeQuery();){
                while (rs.next()) {
                    long playerId = rs.getLong("player_id");
                    String playerName = rs.getString("name");
                    PlayerCache.cacheName(playerId, playerName);
                    logs.add(LogEntryFactory.fromDatabase(rs));
                }
            }
        }
        catch (SQLException e) {
            this.stellarProtect.getLogger().log(Level.SEVERE, "Error in queryLogsFromDB", e);
        }
        Debugger.debugLog("Loaded " + logs.size() + " logs from database.");
        return new CallbackLookup<Set<LogEntry>, Long>(logs, totalCount);
    }

    private CallbackLookup<Map<LocationCache, Set<LogEntry>>, Long> queryLogsFromDB(@NonNull TimeArg timeArg, @NonNull RadiusArg radiusArg, int skip, int limit) {
        if (timeArg == null) {
            throw new NullPointerException("timeArg is marked non-null but is null");
        }
        if (radiusArg == null) {
            throw new NullPointerException("radiusArg is marked non-null but is null");
        }
        LinkedHashSet<LogEntry> logs = new LinkedHashSet<LogEntry>();
        long totalCount = 0L;
        String dataQuery = "SELECT ple.*, p.name, p.uuid FROM log_entries ple JOIN players p ON ple.player_id = p.id WHERE ple.created_at BETWEEN ? AND ? AND ple.x BETWEEN ? AND ? AND ple.y BETWEEN ? AND ? AND ple.z BETWEEN ? AND ? ORDER BY ple.created_at DESC LIMIT ? OFFSET ?";
        String countQuery = "SELECT COUNT(*) FROM log_entries WHERE created_at BETWEEN ? AND ? AND x BETWEEN ? AND ? AND y BETWEEN ? AND ? AND z BETWEEN ? AND ?";
        try (PreparedStatement countStmt = this.connection.prepareStatement(countQuery);){
            countStmt.setLong(1, timeArg.getStart());
            countStmt.setLong(2, timeArg.getEnd());
            countStmt.setDouble(3, radiusArg.getMinX());
            countStmt.setDouble(4, radiusArg.getMaxX());
            countStmt.setDouble(5, radiusArg.getMinY());
            countStmt.setDouble(6, radiusArg.getMaxY());
            countStmt.setDouble(7, radiusArg.getMinZ());
            countStmt.setDouble(8, radiusArg.getMaxZ());
            try (ResultSet resultSet = countStmt.executeQuery();){
                if (resultSet.next()) {
                    totalCount = resultSet.getLong(1);
                }
            }
        }
        catch (SQLException e) {
            this.stellarProtect.getLogger().log(Level.SEVERE, "Error in count", e);
        }
        try (PreparedStatement dataStmt = this.connection.prepareStatement(dataQuery);){
            dataStmt.setLong(1, timeArg.getStart());
            dataStmt.setLong(2, timeArg.getEnd());
            dataStmt.setDouble(3, radiusArg.getMinX());
            dataStmt.setDouble(4, radiusArg.getMaxX());
            dataStmt.setDouble(5, radiusArg.getMinY());
            dataStmt.setDouble(6, radiusArg.getMaxY());
            dataStmt.setDouble(7, radiusArg.getMinZ());
            dataStmt.setDouble(8, radiusArg.getMaxZ());
            dataStmt.setInt(9, limit);
            dataStmt.setInt(10, skip);
            try (ResultSet rs = dataStmt.executeQuery();){
                while (rs.next()) {
                    long playerId = rs.getLong("player_id");
                    String playerName = rs.getString("name");
                    PlayerCache.cacheName(playerId, playerName);
                    logs.add(LogEntryFactory.fromDatabase(rs));
                }
            }
        }
        catch (SQLException e) {
            this.stellarProtect.getLogger().log(Level.SEVERE, "Error in queryLogsFromDB", e);
        }
        Debugger.debugLog("Loaded " + logs.size() + " logs from database.");
        Map groupedLogs = logs.stream().collect(Collectors.groupingBy(LocationCache::of, LinkedHashMap::new, Collectors.toCollection(LinkedHashSet::new)));
        return new CallbackLookup<Map<LocationCache, Set<LogEntry>>, Long>(groupedLogs, totalCount);
    }
}

