/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.database.types.sql;

import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.data.PlayerProtect;
import io.github.InsiderAnh.StellarProtect.database.repositories.PlayerRepository;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import org.bukkit.entity.Player;

public class PlayerRepositorySQL
implements PlayerRepository {
    private final StellarProtect stellarProtect = StellarProtect.getInstance();
    private final Connection connection;

    public PlayerRepositorySQL(Connection connection) {
        this.connection = connection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PlayerProtect loadOrCreatePlayer(Player player) {
        try {
            try (PreparedStatement select = this.connection.prepareStatement("SELECT id FROM players WHERE uuid = ?");){
                select.setString(1, player.getUniqueId().toString());
                try (ResultSet result = select.executeQuery();){
                    if (result.next()) {
                        long id = result.getLong("id");
                        PlayerProtect playerProtect = new PlayerProtect(player.getUniqueId(), id);
                        return playerProtect;
                    }
                }
            }
            long newId = this.generateNextId();
            try (PreparedStatement insert = this.connection.prepareStatement("INSERT INTO players (id, uuid, name) VALUES (?, ?, ?)");){
                insert.setLong(1, newId);
                insert.setString(2, player.getUniqueId().toString());
                insert.setString(3, player.getName());
                insert.executeUpdate();
                return new PlayerProtect(player.getUniqueId(), newId);
            }
        }
        catch (SQLException e) {
            this.stellarProtect.getLogger().log(Level.SEVERE, "Error on loadOrCreatePlayer", e);
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public long generateNextId() {
        try (PreparedStatement getCurrentId = this.connection.prepareStatement("SELECT current_id FROM id_counter WHERE table_name = 'players'");){
            long l;
            block32: {
                ResultSet result;
                block28: {
                    long l2;
                    block30: {
                        result = getCurrentId.executeQuery();
                        try {
                            if (!result.next()) break block28;
                            long currentId = result.getLong("current_id");
                            long newId = currentId + 1L;
                            try (PreparedStatement updateId = this.connection.prepareStatement("UPDATE id_counter SET current_id = ? WHERE table_name = 'players'");){
                                updateId.setLong(1, newId);
                                updateId.executeUpdate();
                            }
                            l2 = newId;
                            if (result == null) break block30;
                        }
                        catch (Throwable throwable) {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        result.close();
                    }
                    return l2;
                }
                try (PreparedStatement initId = this.connection.prepareStatement("INSERT INTO id_counter (table_name, current_id) VALUES ('players', 1)");){
                    initId.executeUpdate();
                }
                l = 1L;
                if (result == null) break block32;
                result.close();
            }
            return l;
        }
        catch (SQLException e) {
            this.stellarProtect.getLogger().log(Level.SEVERE, "Error on generateNextId", e);
            return 0L;
        }
    }
}

