/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.libs.bson;

import io.github.InsiderAnh.StellarProtect.libs.bson.BsonBinaryReader;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonType;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonValue;
import io.github.InsiderAnh.StellarProtect.libs.bson.RawBsonArray;
import io.github.InsiderAnh.StellarProtect.libs.bson.RawBsonDocument;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.BsonValueCodecProvider;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.DecoderContext;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.configuration.CodecRegistries;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.configuration.CodecRegistry;
import io.github.InsiderAnh.StellarProtect.libs.bson.io.BsonInputMark;

final class RawBsonValueHelper {
    private static final CodecRegistry REGISTRY = CodecRegistries.fromProviders(new BsonValueCodecProvider());

    static BsonValue decode(byte[] bytes, BsonBinaryReader bsonReader) {
        if (bsonReader.getCurrentBsonType() == BsonType.DOCUMENT || bsonReader.getCurrentBsonType() == BsonType.ARRAY) {
            int position = bsonReader.getBsonInput().getPosition();
            BsonInputMark mark = bsonReader.getBsonInput().getMark(4);
            int size = bsonReader.getBsonInput().readInt32();
            mark.reset();
            bsonReader.skipValue();
            if (bsonReader.getCurrentBsonType() == BsonType.DOCUMENT) {
                return new RawBsonDocument(bytes, position, size);
            }
            return new RawBsonArray(bytes, position, size);
        }
        return (BsonValue)REGISTRY.get(BsonValueCodecProvider.getClassForBsonType(bsonReader.getCurrentBsonType())).decode(bsonReader, DecoderContext.builder().build());
    }

    private RawBsonValueHelper() {
    }
}

