/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.libs.bson.codecs;

import io.github.InsiderAnh.StellarProtect.libs.bson.BsonArray;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonBinary;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonBoolean;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonDateTime;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonDbPointer;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonDecimal128;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonDocument;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonDocumentWrapper;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonDouble;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonInt32;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonInt64;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonJavaScript;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonJavaScriptWithScope;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonMaxKey;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonMinKey;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonNull;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonObjectId;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonRegularExpression;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonString;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonSymbol;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonTimestamp;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonType;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonUndefined;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonValue;
import io.github.InsiderAnh.StellarProtect.libs.bson.RawBsonDocument;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.BsonArrayCodec;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.BsonBinaryCodec;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.BsonBooleanCodec;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.BsonDBPointerCodec;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.BsonDateTimeCodec;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.BsonDecimal128Codec;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.BsonDocumentCodec;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.BsonDocumentWrapperCodec;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.BsonDoubleCodec;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.BsonInt32Codec;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.BsonInt64Codec;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.BsonJavaScriptCodec;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.BsonJavaScriptWithScopeCodec;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.BsonMaxKeyCodec;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.BsonMinKeyCodec;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.BsonNullCodec;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.BsonObjectIdCodec;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.BsonRegularExpressionCodec;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.BsonStringCodec;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.BsonSymbolCodec;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.BsonTimestampCodec;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.BsonTypeClassMap;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.BsonUndefinedCodec;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.BsonValueCodec;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.Codec;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.RawBsonDocumentCodec;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.configuration.CodecProvider;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.configuration.CodecRegistry;
import java.util.HashMap;
import java.util.Map;

public class BsonValueCodecProvider
implements CodecProvider {
    private static final BsonTypeClassMap DEFAULT_BSON_TYPE_CLASS_MAP;
    private final Map<Class<?>, Codec<?>> codecs = new HashMap();

    public BsonValueCodecProvider() {
        this.addCodecs();
    }

    public static Class<? extends BsonValue> getClassForBsonType(BsonType bsonType) {
        return DEFAULT_BSON_TYPE_CLASS_MAP.get(bsonType);
    }

    public static BsonTypeClassMap getBsonTypeClassMap() {
        return DEFAULT_BSON_TYPE_CLASS_MAP;
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        if (this.codecs.containsKey(clazz)) {
            return this.codecs.get(clazz);
        }
        if (clazz == BsonJavaScriptWithScope.class) {
            return new BsonJavaScriptWithScopeCodec(registry.get(BsonDocument.class));
        }
        if (clazz == BsonValue.class) {
            return new BsonValueCodec(registry);
        }
        if (clazz == BsonDocumentWrapper.class) {
            return new BsonDocumentWrapperCodec(registry.get(BsonDocument.class));
        }
        if (clazz == RawBsonDocument.class) {
            return new RawBsonDocumentCodec();
        }
        if (BsonDocument.class.isAssignableFrom(clazz)) {
            return new BsonDocumentCodec(registry);
        }
        if (BsonArray.class.isAssignableFrom(clazz)) {
            return new BsonArrayCodec(registry);
        }
        return null;
    }

    private void addCodecs() {
        this.addCodec(new BsonNullCodec());
        this.addCodec(new BsonBinaryCodec());
        this.addCodec(new BsonBooleanCodec());
        this.addCodec(new BsonDateTimeCodec());
        this.addCodec(new BsonDBPointerCodec());
        this.addCodec(new BsonDoubleCodec());
        this.addCodec(new BsonInt32Codec());
        this.addCodec(new BsonInt64Codec());
        this.addCodec(new BsonDecimal128Codec());
        this.addCodec(new BsonMinKeyCodec());
        this.addCodec(new BsonMaxKeyCodec());
        this.addCodec(new BsonJavaScriptCodec());
        this.addCodec(new BsonObjectIdCodec());
        this.addCodec(new BsonRegularExpressionCodec());
        this.addCodec(new BsonStringCodec());
        this.addCodec(new BsonSymbolCodec());
        this.addCodec(new BsonTimestampCodec());
        this.addCodec(new BsonUndefinedCodec());
    }

    private <T extends BsonValue> void addCodec(Codec<T> codec) {
        this.codecs.put(codec.getEncoderClass(), codec);
    }

    static {
        HashMap map = new HashMap();
        map.put(BsonType.NULL, BsonNull.class);
        map.put(BsonType.ARRAY, BsonArray.class);
        map.put(BsonType.BINARY, BsonBinary.class);
        map.put(BsonType.BOOLEAN, BsonBoolean.class);
        map.put(BsonType.DATE_TIME, BsonDateTime.class);
        map.put(BsonType.DB_POINTER, BsonDbPointer.class);
        map.put(BsonType.DOCUMENT, BsonDocument.class);
        map.put(BsonType.DOUBLE, BsonDouble.class);
        map.put(BsonType.INT32, BsonInt32.class);
        map.put(BsonType.INT64, BsonInt64.class);
        map.put(BsonType.DECIMAL128, BsonDecimal128.class);
        map.put(BsonType.MAX_KEY, BsonMaxKey.class);
        map.put(BsonType.MIN_KEY, BsonMinKey.class);
        map.put(BsonType.JAVASCRIPT, BsonJavaScript.class);
        map.put(BsonType.JAVASCRIPT_WITH_SCOPE, BsonJavaScriptWithScope.class);
        map.put(BsonType.OBJECT_ID, BsonObjectId.class);
        map.put(BsonType.REGULAR_EXPRESSION, BsonRegularExpression.class);
        map.put(BsonType.STRING, BsonString.class);
        map.put(BsonType.SYMBOL, BsonSymbol.class);
        map.put(BsonType.TIMESTAMP, BsonTimestamp.class);
        map.put(BsonType.UNDEFINED, BsonUndefined.class);
        DEFAULT_BSON_TYPE_CLASS_MAP = new BsonTypeClassMap(map);
    }
}

