/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.libs.bson.internal;

import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.Codec;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.configuration.CodecConfigurationException;
import io.github.InsiderAnh.StellarProtect.libs.bson.internal.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

final class CodecCache {
    private final ConcurrentMap<Class<?>, Optional<? extends Codec<?>>> codecCache = new ConcurrentHashMap();

    CodecCache() {
    }

    public boolean containsKey(Class<?> clazz) {
        return this.codecCache.containsKey(clazz);
    }

    public void put(Class<?> clazz, Codec<?> codec) {
        this.codecCache.put(clazz, Optional.of(codec));
    }

    public synchronized <T> Codec<T> putIfMissing(Class<T> clazz, Codec<T> codec) {
        if (this.codecCache.containsKey(clazz)) {
            return (Codec)((Optional)this.codecCache.get(clazz)).get();
        }
        this.codecCache.put(clazz, Optional.of(codec));
        return codec;
    }

    public <T> Codec<T> getOrThrow(Class<T> clazz) {
        Optional optionalCodec;
        if (this.codecCache.containsKey(clazz) && !(optionalCodec = (Optional)this.codecCache.get(clazz)).isEmpty()) {
            return (Codec)optionalCodec.get();
        }
        throw new CodecConfigurationException(String.format("Can't find a codec for %s.", clazz));
    }
}

