/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.libs.mongodb.client.model;

import io.github.InsiderAnh.StellarProtect.libs.bson.conversions.Bson;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.assertions.Assertions;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.model.ReplaceOptions;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.model.UpdateOptions;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.model.WriteModel;

public final class ReplaceOneModel<T>
extends WriteModel<T> {
    private final Bson filter;
    private final T replacement;
    private final ReplaceOptions options;

    public ReplaceOneModel(Bson filter, T replacement) {
        this(filter, replacement, new ReplaceOptions());
    }

    @Deprecated
    public ReplaceOneModel(Bson filter, T replacement, UpdateOptions options) {
        this(filter, replacement, ReplaceOptions.createReplaceOptions(options));
    }

    public ReplaceOneModel(Bson filter, T replacement, ReplaceOptions options) {
        this.filter = Assertions.notNull("filter", filter);
        this.options = Assertions.notNull("options", options);
        this.replacement = Assertions.notNull("replacement", replacement);
    }

    public Bson getFilter() {
        return this.filter;
    }

    public T getReplacement() {
        return this.replacement;
    }

    @Deprecated
    public UpdateOptions getOptions() {
        return new UpdateOptions().bypassDocumentValidation(this.options.getBypassDocumentValidation()).collation(this.options.getCollation()).upsert(this.options.isUpsert());
    }

    public ReplaceOptions getReplaceOptions() {
        return this.options;
    }

    public String toString() {
        return "ReplaceOneModel{filter=" + this.filter + ", replacement=" + this.replacement + ", options=" + this.options + '}';
    }
}

