/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection;

import io.github.InsiderAnh.StellarProtect.libs.bson.BsonDocument;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonString;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.MongoCommandException;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.MongoSecurityException;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.async.SingleResultCallback;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.connection.ConnectionDescription;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.authentication.NativeAuthenticationHelper;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.Authenticator;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.CommandHelper;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.InternalConnection;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.MongoCredentialWithCache;

class NativeAuthenticator
extends Authenticator {
    NativeAuthenticator(MongoCredentialWithCache credential) {
        super(credential);
    }

    @Override
    public void authenticate(InternalConnection connection, ConnectionDescription connectionDescription) {
        try {
            BsonDocument nonceResponse = CommandHelper.executeCommand(this.getMongoCredential().getSource(), NativeAuthenticationHelper.getNonceCommand(), connection);
            BsonDocument authCommand = NativeAuthenticationHelper.getAuthCommand(this.getUserNameNonNull(), this.getPasswordNonNull(), ((BsonString)nonceResponse.get("nonce")).getValue());
            CommandHelper.executeCommand(this.getMongoCredential().getSource(), authCommand, connection);
        }
        catch (MongoCommandException e) {
            throw new MongoSecurityException(this.getMongoCredential(), "Exception authenticating", (Throwable)e);
        }
    }

    @Override
    void authenticateAsync(final InternalConnection connection, ConnectionDescription connectionDescription, final SingleResultCallback<Void> callback) {
        CommandHelper.executeCommandAsync(this.getMongoCredential().getSource(), NativeAuthenticationHelper.getNonceCommand(), connection, new SingleResultCallback<BsonDocument>(){

            @Override
            public void onResult(BsonDocument nonceResult, Throwable t) {
                if (t != null) {
                    callback.onResult(null, NativeAuthenticator.this.translateThrowable(t));
                } else {
                    CommandHelper.executeCommandAsync(NativeAuthenticator.this.getMongoCredential().getSource(), NativeAuthenticationHelper.getAuthCommand(NativeAuthenticator.this.getUserNameNonNull(), NativeAuthenticator.this.getPasswordNonNull(), ((BsonString)nonceResult.get("nonce")).getValue()), connection, new SingleResultCallback<BsonDocument>(){

                        @Override
                        public void onResult(BsonDocument result, Throwable t) {
                            if (t != null) {
                                callback.onResult(null, NativeAuthenticator.this.translateThrowable(t));
                            } else {
                                callback.onResult(null, null);
                            }
                        }
                    });
                }
            }
        });
    }

    private Throwable translateThrowable(Throwable t) {
        if (t instanceof MongoCommandException) {
            return new MongoSecurityException(this.getMongoCredential(), "Exception authenticating", t);
        }
        return t;
    }
}

