/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.libs.mongodb.operation;

import io.github.InsiderAnh.StellarProtect.libs.bson.BsonBoolean;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonDocument;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonInt32;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonInt64;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.Decoder;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.assertions.Assertions;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.async.AsyncBatchCursor;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.async.SingleResultCallback;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.binding.AsyncConnectionSource;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.binding.AsyncReadBinding;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.binding.ConnectionSource;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.binding.ReadBinding;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.connection.AsyncConnection;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.connection.Connection;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.connection.ConnectionDescription;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.connection.QueryResult;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.connection.ServerDescription;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.async.ErrorHandlingResultCallback;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.operation.AsyncQueryBatchCursor;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.operation.AsyncReadOperation;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.operation.BatchCursor;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.operation.BsonDocumentWrapperHelper;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.operation.CommandOperationHelper;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.operation.CommandResultDocumentCodec;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.operation.OperationHelper;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.operation.QueryBatchCursor;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.operation.ReadOperation;
import java.util.concurrent.TimeUnit;

@Deprecated
public class ListDatabasesOperation<T>
implements AsyncReadOperation<AsyncBatchCursor<T>>,
ReadOperation<BatchCursor<T>> {
    private final Decoder<T> decoder;
    private boolean retryReads;
    private long maxTimeMS;
    private BsonDocument filter;
    private Boolean nameOnly;

    public ListDatabasesOperation(Decoder<T> decoder) {
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public ListDatabasesOperation<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public ListDatabasesOperation<T> filter(BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public ListDatabasesOperation<T> nameOnly(Boolean nameOnly) {
        this.nameOnly = nameOnly;
        return this;
    }

    public ListDatabasesOperation<T> retryReads(boolean retryReads) {
        this.retryReads = retryReads;
        return this;
    }

    public boolean getRetryReads() {
        return this.retryReads;
    }

    public Boolean getNameOnly() {
        return this.nameOnly;
    }

    @Override
    public BatchCursor<T> execute(ReadBinding binding) {
        return CommandOperationHelper.executeCommand(binding, "admin", this.getCommandCreator(), CommandResultDocumentCodec.create(this.decoder, "databases"), this.transformer(), this.retryReads);
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<AsyncBatchCursor<T>> callback) {
        CommandOperationHelper.executeCommandAsync(binding, "admin", this.getCommandCreator(), CommandResultDocumentCodec.create(this.decoder, "databases"), this.asyncTransformer(), this.retryReads, ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER));
    }

    private CommandOperationHelper.CommandReadTransformer<BsonDocument, BatchCursor<T>> transformer() {
        return new CommandOperationHelper.CommandReadTransformer<BsonDocument, BatchCursor<T>>(){

            @Override
            public BatchCursor<T> apply(BsonDocument result, ConnectionSource source, Connection connection) {
                return new QueryBatchCursor(ListDatabasesOperation.this.createQueryResult(result, connection.getDescription()), 0, 0, ListDatabasesOperation.this.decoder, source);
            }
        };
    }

    private CommandOperationHelper.CommandReadTransformerAsync<BsonDocument, AsyncBatchCursor<T>> asyncTransformer() {
        return new CommandOperationHelper.CommandReadTransformerAsync<BsonDocument, AsyncBatchCursor<T>>(){

            @Override
            public AsyncBatchCursor<T> apply(BsonDocument result, AsyncConnectionSource source, AsyncConnection connection) {
                return new AsyncQueryBatchCursor(ListDatabasesOperation.this.createQueryResult(result, connection.getDescription()), 0, 0, 0L, ListDatabasesOperation.this.decoder, source, connection, result);
            }
        };
    }

    private QueryResult<T> createQueryResult(BsonDocument result, ConnectionDescription description) {
        return new QueryResult(null, BsonDocumentWrapperHelper.toList(result, "databases"), 0L, description.getServerAddress());
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return new CommandOperationHelper.CommandCreator(){

            @Override
            public BsonDocument create(ServerDescription serverDescription, ConnectionDescription connectionDescription) {
                return ListDatabasesOperation.this.getCommand();
            }
        };
    }

    private BsonDocument getCommand() {
        BsonDocument command = new BsonDocument("listDatabases", new BsonInt32(1));
        if (this.maxTimeMS > 0L) {
            command.put("maxTimeMS", new BsonInt64(this.maxTimeMS));
        }
        if (this.filter != null) {
            command.put("filter", this.filter);
        }
        if (this.nameOnly != null) {
            command.put("nameOnly", new BsonBoolean(this.nameOnly));
        }
        return command;
    }
}

