/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.listeners.handlers.interacts;

import io.github.InsiderAnh.StellarProtect.cache.LoggerCache;
import io.github.InsiderAnh.StellarProtect.data.PlayerProtect;
import io.github.InsiderAnh.StellarProtect.database.entries.players.PlayerBlockLogEntry;
import io.github.InsiderAnh.StellarProtect.database.entries.players.PlayerUseEntry;
import io.github.InsiderAnh.StellarProtect.enums.ActionType;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.lang.Nullable;
import io.github.InsiderAnh.StellarProtect.listeners.handlers.GenericHandler;
import io.github.InsiderAnh.StellarProtect.utils.WorldUtils;
import lombok.NonNull;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class PlayerUseHandler
extends GenericHandler {
    @Override
    public GenericHandler canHandle(@NonNull Block block, @Nullable ItemStack itemStack) {
        if (block == null) {
            throw new NullPointerException("block is marked non-null but is null");
        }
        if (WorldUtils.isInteractable(block.getType().name())) {
            return this;
        }
        return null;
    }

    @Override
    public void handle(Player player, @NonNull Block block, ItemStack itemStack) {
        if (block == null) {
            throw new NullPointerException("block is marked non-null but is null");
        }
        PlayerProtect playerProtect = PlayerProtect.getPlayer(player);
        if (playerProtect == null) {
            return;
        }
        if (WorldUtils.isToggleableState(block.getType().name())) {
            LoggerCache.addLog(new PlayerBlockLogEntry(playerProtect.getPlayerId(), block, ActionType.INTERACT));
        } else {
            LoggerCache.addLog(new PlayerUseEntry(playerProtect.getPlayerId(), block, ActionType.USE));
        }
    }
}

