/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.managers;

import com.google.gson.Gson;
import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.cache.keys.LocationCache;
import io.github.InsiderAnh.StellarProtect.database.entries.LogEntry;
import io.github.InsiderAnh.StellarProtect.database.entries.players.PlayerBlockLogEntry;
import io.github.InsiderAnh.StellarProtect.enums.ActionType;
import io.github.InsiderAnh.StellarProtect.restore.BlockRestore;
import io.github.InsiderAnh.StellarProtect.utils.SerializerUtils;
import java.util.Map;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;

public class RestoreManager {
    private final StellarProtect plugin = StellarProtect.getInstance();

    public void rollback(CommandSender sender, Map<LocationCache, Set<LogEntry>> groupedLogs) {
        Gson gson = SerializerUtils.getGson();
        int processedCount = 0;
        int MAX_PER_TICK = 50;
        block2: for (Map.Entry<LocationCache, Set<LogEntry>> entry : groupedLogs.entrySet()) {
            for (LogEntry logEntry : entry.getValue()) {
                if (!(logEntry instanceof PlayerBlockLogEntry)) continue;
                PlayerBlockLogEntry blockLogEntry = (PlayerBlockLogEntry)logEntry;
                Location location = blockLogEntry.asBukkitLocation();
                BlockRestore blockRestore = this.plugin.getBlockRestore(blockLogEntry.getData());
                if (blockLogEntry.getActionType() == ActionType.BLOCK_PLACE.getId()) {
                    blockRestore.remove(location);
                } else if (blockLogEntry.getActionType() == ActionType.BLOCK_BREAK.getId()) {
                    blockRestore.reset(gson, location);
                }
                if (++processedCount % 50 != 0) continue;
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    continue block2;
                }
            }
        }
    }
}

