/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.utils;

import io.github.InsiderAnh.StellarProtect.items.MinecraftItem;
import java.util.HashMap;

public class StringCleanerUtils {
    public static final String COMMON_BASE64 = "rO0ABXNyABpvcmcuYnVra2l0LnV0aWwuaW8uV3JhcHBlcvJQR+zxEm8FAgABTAADbWFwdAAPTGphdmEvdXRpbC9NYXA7eHBzcgA1Y29tLmdvb2dsZS5jb21tb24uY29sbGVjdC5JbW11dGFibGVNYXAkU2VyaWFsaXplZEZvcm0AAAAAAAAAAAIAAkwABGtleXN0ABJMamF2YS9sYW5nL09iamVjdDtMAAZ2YWx1ZXNxAH4ABHhwdXIAE1tMamF2YS5sYW5nLk9iamVjdDuQzlifEHMpbAIAAHhwAAAABXQAAj09dAALRGF0YVZlcnNpb250AAJpZHQABWNvdW50dAAOc2NoZW1hX3ZlcnNpb251cQB+AAYAAAAFdAAeb3JnLmJ1a2tpdC5pbnZlbnRvcnkuSXRlbVN0YWNrc3IAEWphdmEubGFuZy5JbnRlZ2VyEuKgpPeB";

    private static String cleanMinecraftName(String name) {
        if (name == null || name.length() < 2) {
            return name;
        }
        String cleanedData = name.startsWith("minecraft:") ? name.replaceFirst("minecraft:", "") : name;
        int bracketIndex = cleanedData.indexOf(91);
        if (bracketIndex != -1) {
            cleanedData = cleanedData.substring(0, bracketIndex);
        }
        StringBuilder builder = new StringBuilder();
        for (String word : cleanedData.split("_")) {
            if (word.isEmpty()) continue;
            builder.append(word.substring(0, 1).toUpperCase()).append(word.substring(1).toLowerCase()).append(" ");
        }
        return builder.toString().trim();
    }

    public static MinecraftItem parseMinecraftData(String data) {
        String itemName;
        if (data == null || data.isEmpty()) {
            return new MinecraftItem("", new HashMap<String, String>());
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        int bracketIndex = data.indexOf(91);
        if (bracketIndex != -1) {
            itemName = data.substring(0, bracketIndex);
            String propertiesString = data.substring(bracketIndex + 1, data.lastIndexOf(93));
            if (!propertiesString.isEmpty()) {
                String[] pairs;
                for (String pair : pairs = propertiesString.split(",")) {
                    String[] keyValue = pair.trim().split("=");
                    if (keyValue.length != 2) continue;
                    String key = keyValue[0].trim();
                    String value = keyValue[1].trim();
                    key = key.substring(0, 1).toUpperCase() + key.substring(1);
                    value = value.substring(0, 1).toUpperCase() + value.substring(1);
                    properties.put(key, value);
                }
            }
        } else {
            itemName = data;
        }
        String cleanName = StringCleanerUtils.cleanMinecraftName(itemName);
        return new MinecraftItem(cleanName, properties);
    }
}

