/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.commands;

import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.commands.StellarArgument;
import io.github.insideranh.stellarprotect.commands.StellarCompleter;
import io.github.insideranh.stellarprotect.commands.arguments.InventoryRollbackArgument;
import io.github.insideranh.stellarprotect.commands.arguments.InventoryRollbackSessionArgument;
import io.github.insideranh.stellarprotect.commands.arguments.PurgeArgument;
import io.github.insideranh.stellarprotect.commands.arguments.RestoreArgument;
import io.github.insideranh.stellarprotect.commands.arguments.RestoreSessionArgument;
import io.github.insideranh.stellarprotect.commands.arguments.TeleportArgument;
import io.github.insideranh.stellarprotect.commands.arguments.UndoArgument;
import io.github.insideranh.stellarprotect.commands.arguments.UndoSessionArgument;
import io.github.insideranh.stellarprotect.commands.arguments.basic.DebugArgument;
import io.github.insideranh.stellarprotect.commands.arguments.basic.MemoryArgument;
import io.github.insideranh.stellarprotect.commands.arguments.basic.VersionArgument;
import io.github.insideranh.stellarprotect.commands.arguments.lookups.InspectArgument;
import io.github.insideranh.stellarprotect.commands.arguments.lookups.LookupArgument;
import io.github.insideranh.stellarprotect.commands.arguments.lookups.NextInspectArgument;
import io.github.insideranh.stellarprotect.commands.arguments.lookups.NextLookupArgument;
import io.github.insideranh.stellarprotect.commands.arguments.views.ViewArgument;
import io.github.insideranh.stellarprotect.commands.completers.LookupCompleter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;

public class StellarProtectCMD
implements TabExecutor {
    private final StellarProtect plugin = StellarProtect.getInstance();
    private final HashMap<String, StellarArgument> arguments = new HashMap();
    private final HashMap<String, StellarCompleter> completes = new HashMap();

    public StellarProtectCMD() {
        this.arguments.put("lookup", new LookupArgument());
        this.arguments.put("nextlookup", new NextLookupArgument());
        this.arguments.put("inspect", new InspectArgument());
        this.arguments.put("purge", new PurgeArgument());
        this.arguments.put("nextinspect", new NextInspectArgument());
        this.arguments.put("debug", new DebugArgument());
        this.arguments.put("memory", new MemoryArgument());
        this.arguments.put("version", new VersionArgument());
        this.arguments.put("restore", new RestoreArgument());
        this.arguments.put("teleport", new TeleportArgument());
        this.arguments.put("view", new ViewArgument());
        this.arguments.put("rs", new RestoreSessionArgument());
        this.arguments.put("undo", new UndoArgument());
        this.arguments.put("us", new UndoSessionArgument());
        this.arguments.put("invrollback", new InventoryRollbackArgument());
        this.arguments.put("irs", new InventoryRollbackSessionArgument());
        this.completes.put("lookup", new LookupCompleter());
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length < 1) {
            if (this.hasBlockedPermission(sender, "default")) {
                return false;
            }
            this.sendHelp(sender);
            return false;
        }
        switch (args[0].toLowerCase()) {
            case "rs": {
                if (this.hasBlockedPermission(sender, "rollback")) {
                    return false;
                }
                this.arguments.get("rs").onCommand(sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "reload": {
                if (this.hasBlockedPermission(sender, "admin")) {
                    return false;
                }
                this.plugin.reload();
                this.plugin.getLangManager().sendMessage(sender, "messages.reloaded");
                break;
            }
            case "i": 
            case "inspect": {
                if (this.hasBlockedPermission(sender, "inspect")) {
                    return false;
                }
                this.arguments.get("inspect").onCommand(sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "ni": 
            case "nextinspect": {
                if (this.hasBlockedPermission(sender, "inspect")) {
                    return false;
                }
                this.arguments.get("nextinspect").onCommand(sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "t": 
            case "teleport": {
                if (this.hasBlockedPermission(sender, "lookup") && this.hasBlockedPermission(sender, "teleport")) {
                    return false;
                }
                this.arguments.get("teleport").onCommand(sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "s": 
            case "l": 
            case "search": 
            case "lookup": {
                if (this.hasBlockedPermission(sender, "lookup")) {
                    return false;
                }
                this.arguments.get("lookup").onCommand(sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "nl": 
            case "nextlookup": {
                if (this.hasBlockedPermission(sender, "lookup")) {
                    return false;
                }
                this.arguments.get("nextlookup").onCommand(sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "view": {
                if (this.hasBlockedPermission(sender, "view")) {
                    return false;
                }
                this.arguments.get("view").onCommand(sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "purge": {
                if (this.hasBlockedPermission(sender, "purge")) {
                    return false;
                }
                this.arguments.get("purge").onCommand(sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "debug": {
                if (this.hasBlockedPermission(sender, "admin")) {
                    return false;
                }
                this.arguments.get("debug").onCommand(sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "v": 
            case "version": {
                if (this.hasBlockedPermission(sender, "default")) {
                    return false;
                }
                this.arguments.get("version").onCommand(sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "mem": 
            case "memory": {
                if (this.hasBlockedPermission(sender, "memory")) {
                    return false;
                }
                this.arguments.get("memory").onCommand(sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "r": 
            case "restore": 
            case "rollback": {
                if (this.hasBlockedPermission(sender, "rollback")) {
                    return false;
                }
                this.arguments.get("restore").onCommand(sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "u": 
            case "undo": {
                if (this.hasBlockedPermission(sender, "rollback")) {
                    return false;
                }
                this.arguments.get("undo").onCommand(sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "us": {
                if (this.hasBlockedPermission(sender, "rollback")) {
                    return false;
                }
                this.arguments.get("us").onCommand(sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "invrollback": 
            case "inventoryrollback": {
                if (this.hasBlockedPermission(sender, "rollback")) {
                    return false;
                }
                this.arguments.get("invrollback").onCommand(sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "irs": {
                if (this.hasBlockedPermission(sender, "rollback")) {
                    return false;
                }
                this.arguments.get("irs").onCommand(sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            default: {
                if (this.hasBlockedPermission(sender, "default")) {
                    return false;
                }
                this.sendHelp(sender);
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        String arg;
        if (args.length <= 1) {
            String arg2 = args.length == 1 ? args[0].toLowerCase() : "";
            return Stream.of("reload", "version", "help", "lookup", "inspect", "purge", "memory", "debug", "restore", "undo").filter(s -> arg2.isEmpty() || s.startsWith(arg2)).collect(Collectors.toList());
        }
        switch (arg = args[0].toLowerCase()) {
            case "rs": {
                return this.arguments.get("rs").onTabComplete(sender, Arrays.copyOfRange(args, 1, args.length));
            }
            case "us": {
                return this.arguments.get("us").onTabComplete(sender, Arrays.copyOfRange(args, 1, args.length));
            }
            case "invrollback": 
            case "inventoryrollback": {
                return this.arguments.get("invrollback").onTabComplete(sender, Arrays.copyOfRange(args, 1, args.length));
            }
            case "irs": {
                return this.arguments.get("irs").onTabComplete(sender, Arrays.copyOfRange(args, 1, args.length));
            }
            case "inspect": 
            case "i": {
                return this.arguments.get("inspect").onTabComplete(sender, Arrays.copyOfRange(args, 1, args.length));
            }
            case "search": 
            case "lookup": 
            case "s": 
            case "l": {
                return this.completes.get("lookup").onTabComplete(sender, Arrays.copyOfRange(args, 1, args.length));
            }
            case "purge": {
                return this.arguments.get("purge").onTabComplete(sender, Arrays.copyOfRange(args, 1, args.length));
            }
            case "debug": {
                return this.arguments.get("debug").onTabComplete(sender, Arrays.copyOfRange(args, 1, args.length));
            }
            case "mem": 
            case "memory": {
                return this.arguments.get("memory").onTabComplete(sender, Arrays.copyOfRange(args, 1, args.length));
            }
            case "r": 
            case "restore": 
            case "rollback": {
                return this.arguments.get("restore").onTabComplete(sender, Arrays.copyOfRange(args, 1, args.length));
            }
            case "u": 
            case "undo": {
                return this.arguments.get("undo").onTabComplete(sender, Arrays.copyOfRange(args, 1, args.length));
            }
        }
        return Stream.of("reload", "version", "help", "lookup", "inspect", "purge", "memory", "debug", "restore", "undo").filter(s -> s.startsWith(arg)).collect(Collectors.toList());
    }

    void sendHelp(CommandSender sender) {
        this.plugin.getLangManager().sendMessage(sender, "messages.help.headerTop");
        this.plugin.getLangManager().sendMessage(sender, "messages.help.title");
        this.plugin.getLangManager().sendMessage(sender, "messages.help.headerBottom");
        this.plugin.getLangManager().sendMessage(sender, "messages.help.reload");
        this.plugin.getLangManager().sendMessage(sender, "messages.help.help");
        this.plugin.getLangManager().sendMessage(sender, "messages.help.version");
        if (!this.hasBlockedPermission(sender, "inspect")) {
            this.plugin.getLangManager().sendMessage(sender, "messages.help.inspect");
        }
        if (!this.hasBlockedPermission(sender, "lookup")) {
            this.plugin.getLangManager().sendMessage(sender, "messages.help.lookup");
        }
        if (!this.hasBlockedPermission(sender, "rollback")) {
            this.plugin.getLangManager().sendMessage(sender, "messages.help.restore");
            this.plugin.getLangManager().sendMessage(sender, "messages.help.undo");
            this.plugin.getLangManager().sendMessage(sender, "messages.help.invrollback");
            this.plugin.getLangManager().sendMessage(sender, "messages.help.irs");
        }
        if (!this.hasBlockedPermission(sender, "purge")) {
            this.plugin.getLangManager().sendMessage(sender, "messages.help.purge");
        }
        if (!this.hasBlockedPermission(sender, "admin")) {
            this.plugin.getLangManager().sendMessage(sender, "messages.help.debug");
            this.plugin.getLangManager().sendMessage(sender, "messages.help.memory");
        }
    }

    boolean hasBlockedPermission(CommandSender sender, String permission) {
        if (sender.hasPermission("stellarprotect." + permission) || sender.hasPermission("stellarprotect.admin") || sender.isOp()) {
            return false;
        }
        this.plugin.getLangManager().sendMessage(sender, "messages.noPermission");
        return true;
    }
}

