/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.commands.arguments;

import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.commands.StellarArgument;
import io.github.insideranh.stellarprotect.data.InventoryRollbackSession;
import io.github.insideranh.stellarprotect.data.PlayerProtect;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class InventoryRollbackSessionArgument
extends StellarArgument {
    private final StellarProtect plugin = StellarProtect.getInstance();

    @Override
    public void onCommand(@NotNull CommandSender sender, String[] arguments) {
        String subCommand;
        if (!(sender instanceof Player)) {
            this.plugin.getLangManager().sendMessage(sender, "messages.onlyPlayer");
            return;
        }
        Player player = (Player)sender;
        PlayerProtect playerProtect = PlayerProtect.getPlayer(player);
        if (playerProtect == null) {
            return;
        }
        InventoryRollbackSession session = playerProtect.getInventoryRollbackSession();
        if (session == null) {
            this.plugin.getLangManager().sendMessage((CommandSender)player, "messages.inventoryRollback.noActiveSession");
            return;
        }
        if (arguments.length == 0) {
            this.showSessionStatus(player, session);
            return;
        }
        switch (subCommand = arguments[0].toLowerCase()) {
            case "toggle": {
                boolean isActive = this.plugin.getChestRollbackSessionManager().toggleInventoryRollbackMode(player);
                if (isActive) {
                    this.plugin.getLangManager().sendMessage((CommandSender)player, "messages.inventoryRollback.modeEnabled");
                    break;
                }
                this.plugin.getLangManager().sendMessage((CommandSender)player, "messages.inventoryRollback.modeDisabled");
                break;
            }
            case "stop": 
            case "cancel": 
            case "exit": {
                playerProtect.setInventoryRollbackSession(null);
                this.plugin.getLangManager().sendMessage((CommandSender)player, "messages.inventoryRollback.sessionStopped");
                break;
            }
            case "status": 
            case "info": {
                this.showSessionStatus(player, session);
                break;
            }
            default: {
                player.sendMessage("\u00a7cUso: /sp irs <toggle|stop|status>");
            }
        }
    }

    private void showSessionStatus(Player player, InventoryRollbackSession session) {
        player.sendMessage("\u00a77\u00a7m----------------------------------");
        player.sendMessage("\u00a76Sesi\u00f3n de Rollback de Inventarios");
        player.sendMessage("\u00a77Estado: " + (session.isActive() ? "\u00a7aActivo" : "\u00a7cInactivo"));
        player.sendMessage("\u00a77Verbose: " + (session.isVerbose() ? "\u00a7aS\u00ed" : "\u00a7cNo"));
        player.sendMessage("\u00a77Silent: " + (session.isSilent() ? "\u00a7aS\u00ed" : "\u00a7cNo"));
        if (session.getDatabaseFilters().getTimeFilter() != null) {
            player.sendMessage("\u00a77Tiempo: \u00a7f" + this.formatTime(session.getDatabaseFilters().getTimeFilter().getStart()));
        }
        if (session.getDatabaseFilters().getRadiusFilter() != null) {
            player.sendMessage("\u00a77Radio: \u00a7f" + session.getDatabaseFilters().getRadiusFilter().getRadius());
        }
        player.sendMessage("\u00a77\u00a7m----------------------------------");
        player.sendMessage("\u00a7eComandos:");
        player.sendMessage("\u00a7f/sp irs toggle \u00a77- Activar/desactivar modo");
        player.sendMessage("\u00a7f/sp irs stop \u00a77- Detener sesi\u00f3n");
    }

    private String formatTime(long timestamp) {
        long diff = System.currentTimeMillis() - timestamp;
        long hours = diff / 3600000L;
        long minutes = diff % 3600000L / 60000L;
        if (hours > 0L) {
            return hours + "h " + minutes + "m atr\u00e1s";
        }
        return minutes + "m atr\u00e1s";
    }

    @Override
    public List<String> onTabComplete(@NotNull CommandSender sender, String[] arguments) {
        if (arguments.length == 1) {
            return Arrays.asList("toggle", "stop", "status");
        }
        return Arrays.asList(new String[0]);
    }
}

