/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.commands.arguments;

import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.arguments.ArgumentsParser;
import io.github.insideranh.stellarprotect.arguments.DatabaseFilters;
import io.github.insideranh.stellarprotect.arguments.HashTagsArg;
import io.github.insideranh.stellarprotect.arguments.RadiusArg;
import io.github.insideranh.stellarprotect.arguments.TimeArg;
import io.github.insideranh.stellarprotect.arguments.UsersArg;
import io.github.insideranh.stellarprotect.cache.BlocksCache;
import io.github.insideranh.stellarprotect.cache.ItemsCache;
import io.github.insideranh.stellarprotect.commands.StellarArgument;
import io.github.insideranh.stellarprotect.data.PlayerProtect;
import io.github.insideranh.stellarprotect.data.UndoSession;
import io.github.insideranh.stellarprotect.enums.ActionType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class UndoArgument
extends StellarArgument {
    private final StellarProtect plugin = StellarProtect.getInstance();

    @Override
    public void onCommand(@NotNull CommandSender sender, String[] arguments) {
        List<ActionType> actionTypes;
        RadiusArg radiusArg;
        if (!(sender instanceof Player)) {
            this.plugin.getLangManager().sendMessage(sender, "messages.onlyPlayer");
            return;
        }
        Player player = (Player)sender;
        PlayerProtect playerProtect = PlayerProtect.getPlayer(player);
        if (playerProtect == null) {
            return;
        }
        HashTagsArg hashTagsArg = new HashTagsArg(arguments);
        TimeArg timeArg = ArgumentsParser.parseTime(arguments);
        if (timeArg == null) {
            long fiveMinutesAgo = System.currentTimeMillis() - 300000L;
            timeArg = new TimeArg("5m", "now", fiveMinutesAgo, System.currentTimeMillis());
        }
        if ((radiusArg = ArgumentsParser.parseRadiusOrNull(player, arguments, player.getLocation())) == null) {
            radiusArg = new RadiusArg(player.getLocation(), 10.0, -1);
            this.plugin.getLangManager().sendMessage((CommandSender)player, "messages.specifyRadius");
        }
        List<ActionType> actionTypesArg = ArgumentsParser.parseActionTypes(arguments);
        List<String> includesArg = ArgumentsParser.parseIncludesMaterials(arguments);
        List<String> excludesArg = ArgumentsParser.parseExcludesMaterials(arguments);
        Map<String, List<String>> includesMap = ArgumentsParser.parseIncludeMaterials(arguments);
        Map<String, List<String>> excludesMap = ArgumentsParser.parseExcludeMaterials(arguments);
        if (actionTypesArg.isEmpty()) {
            actionTypes = new LinkedList<ActionType>(Arrays.asList(ActionType.BLOCK_BREAK, ActionType.BLOCK_PLACE, ActionType.BUCKET_EMPTY, ActionType.BUCKET_FILL, ActionType.BLOCK_SPREAD, ActionType.INVENTORY_TRANSACTION));
            if (hashTagsArg.isEntities()) {
                actionTypes.add(ActionType.KILL_ENTITY);
            }
        } else {
            actionTypes = actionTypesArg;
        }
        ItemsCache itemsCache = StellarProtect.getInstance().getItemsManager().getItemCache();
        BlocksCache blocksCache = StellarProtect.getInstance().getBlocksManager().getBlocksCache();
        RadiusArg finalRadiusArg = radiusArg;
        TimeArg finalTimeArg = timeArg;
        ArgumentsParser.parseUsers(arguments).thenAccept(usersArg -> {
            DatabaseFilters databaseFilters = new DatabaseFilters();
            databaseFilters.setTimeFilter(finalTimeArg);
            databaseFilters.setRadiusFilter(finalRadiusArg);
            databaseFilters.setActionTypesFilter(actionTypes.stream().map(ActionType::getId).collect(Collectors.toCollection(ArrayList::new)));
            databaseFilters.setUserFilters((UsersArg)usersArg);
            databaseFilters.setAllIncludeFilters(itemsCache.findIdsByTypeNameContains(includesArg, ItemsCache.FieldType.LOWER_TYPE_NAME));
            databaseFilters.setAllExcludeFilters(itemsCache.findIdsByTypeNameContains(excludesArg, ItemsCache.FieldType.LOWER_TYPE_NAME));
            databaseFilters.setIncludeBlockFilters(blocksCache.findIdsByTypeNameContains(includesArg, BlocksCache.FieldType.LOWER_TYPE_NAME));
            databaseFilters.setExcludeBlockFilters(blocksCache.findIdsByTypeNameContains(excludesArg, BlocksCache.FieldType.LOWER_TYPE_NAME));
            databaseFilters.setIncludeMaterialFilters(itemsCache.findIdsContains(includesMap));
            databaseFilters.setExcludeMaterialFilters(itemsCache.findIdsContains(excludesMap));
            if (hashTagsArg.isSession()) {
                UndoSession session = new UndoSession(player, databaseFilters, hashTagsArg.isVerbose(), hashTagsArg.isSilent());
                playerProtect.setUndoSession(session);
                this.plugin.getUndoSessionManager().showUndoSession(session);
                return;
            }
            this.executeUndo(player, hashTagsArg.isPreview(), hashTagsArg.isVerbose(), hashTagsArg.isSilent(), databaseFilters);
        });
    }

    @Override
    public List<String> onTabComplete(@NotNull CommandSender sender, String[] arguments) {
        if (arguments.length >= 1) {
            String currentArg = arguments[arguments.length - 1].toLowerCase();
            if (currentArg.startsWith("t:") || currentArg.startsWith("time:")) {
                return Arrays.asList("t:1m", "t:2m", "t:3m", "t:5m", "t:1m-5m");
            }
            if (currentArg.startsWith("r:") || currentArg.startsWith("radius:")) {
                return Arrays.asList("r:10", "r:20", "r:50", "r:#world", "r:10,10,10");
            }
            if (currentArg.startsWith("a:") || currentArg.startsWith("action:")) {
                return Arrays.asList("a:block_break", "a:block_place", "a:inventory_transaction", "a:kill_entity", "a:block_spread");
            }
            if (currentArg.startsWith("u:") || currentArg.startsWith("users:")) {
                return Arrays.asList("u:player1", "u:player1,player2", "u:=fire", "u:=natural");
            }
            if (currentArg.startsWith("i:") || currentArg.startsWith("include:")) {
                return Arrays.asList("i:diamond", "i:stone,dirt", "i:ore");
            }
            if (currentArg.startsWith("e:") || currentArg.startsWith("exclude:")) {
                return Arrays.asList("e:air", "e:stone", "e:dirt");
            }
            return Stream.of("t:1m", "t:2m", "t:5m", "r:10", "a:", "u:", "i:", "e:", "mi:", "me:", "#session", "#preview", "#verbose", "#silent", "#count", "#entities").filter(name -> name.contains(currentArg)).collect(Collectors.toList());
        }
        return Arrays.asList("t:1m", "t:5m", "r:10", "a:", "u:", "i:", "e:", "#session", "#preview", "#verbose", "#silent", "#count", "#entities");
    }

    public void executeUndo(Player player, boolean preview, boolean verbose, boolean silent, DatabaseFilters filters) {
        int BATCH_SIZE = 1000;
        int DELAY_TICKS = 2;
        ((CompletableFuture)this.plugin.getProtectDatabase().countRestoreActions(filters).thenAccept(totalLogs -> {
            if (totalLogs == 0L) {
                this.plugin.getLangManager().sendMessage((CommandSender)player, "messages.noLogs");
                return;
            }
            if (!silent) {
                if (verbose) {
                    player.sendMessage(this.plugin.getLangManager().get("messages.undo.start-verbose").replace("<total>", String.valueOf(totalLogs)).replace("<batch>", String.valueOf(1000)));
                } else {
                    player.sendMessage(this.plugin.getLangManager().get("messages.undo.start").replace("<total>", String.valueOf(totalLogs)).replace("<batch>", String.valueOf(1000)));
                }
            }
            this.processBatchUndo(player, preview, verbose, silent, filters, 0, (long)totalLogs, 1000, 2);
        })).exceptionally(error -> {
            this.plugin.getLangManager().sendMessage((CommandSender)player, "messages.error");
            error.printStackTrace();
            return null;
        });
    }

    private void processBatchUndo(Player player, boolean preview, boolean verbose, boolean silent, DatabaseFilters filters, int currentSkip, long totalLogs, int batchSize, int delayTicks) {
        if ((long)currentSkip >= totalLogs) {
            if (!silent) {
                player.sendMessage(this.plugin.getLangManager().get("messages.undo.success").replace("<current>", String.valueOf(currentSkip)).replace("<total>", String.valueOf(totalLogs)));
            }
            return;
        }
        ((CompletableFuture)this.plugin.getProtectDatabase().getRestoreActions(filters, currentSkip, batchSize).thenAccept(callbackLookup -> {
            Map groupedLogs = (Map)callbackLookup.getLogs();
            int processedInBatch = groupedLogs.values().stream().mapToInt(Set::size).sum();
            if (processedInBatch > 0) {
                this.plugin.getStellarTaskHook(() -> {
                    if (preview) {
                        this.plugin.getUndoManager().preview(player, groupedLogs, verbose, silent);
                    } else {
                        this.plugin.getUndoManager().undo((CommandSender)player, groupedLogs, verbose);
                    }
                    int totalProcessed = currentSkip + processedInBatch;
                    double progress = (double)totalProcessed * 100.0 / (double)totalLogs;
                    if (!silent) {
                        if (preview) {
                            if (verbose) {
                                player.sendMessage(this.plugin.getLangManager().get("messages.undo.preview-verbose").replace("<progress>", String.valueOf(Math.round(progress))).replace("<now>", String.valueOf(totalProcessed)).replace("<total>", String.valueOf(totalLogs)));
                            } else {
                                player.sendMessage(this.plugin.getLangManager().get("messages.undo.preview").replace("<progress>", String.valueOf(Math.round(progress))).replace("<now>", String.valueOf(totalProcessed)).replace("<total>", String.valueOf(totalLogs)));
                            }
                        } else if (verbose) {
                            player.sendMessage(this.plugin.getLangManager().get("messages.undo.progress-verbose").replace("<progress>", String.valueOf(Math.round(progress))).replace("<now>", String.valueOf(totalProcessed)).replace("<total>", String.valueOf(totalLogs)));
                        } else {
                            player.sendMessage(this.plugin.getLangManager().get("messages.undo.progress").replace("<progress>", String.valueOf(Math.round(progress))).replace("<now>", String.valueOf(totalProcessed)).replace("<total>", String.valueOf(totalLogs)));
                        }
                    }
                    this.plugin.getStellarTaskHook(() -> this.processBatchUndo(player, preview, verbose, silent, filters, currentSkip + batchSize, totalLogs, batchSize, delayTicks)).runTask(delayTicks);
                }).runTask();
            } else {
                player.sendMessage(this.plugin.getLangManager().get("messages.undo.success").replace("<current>", String.valueOf(currentSkip)).replace("<total>", String.valueOf(totalLogs)));
            }
        })).exceptionally(error -> {
            player.sendMessage(this.plugin.getLangManager().get("messages.undo.error").replace("<section>", String.valueOf(currentSkip / batchSize + 1)).replace("<error>", error.getMessage()));
            error.printStackTrace();
            return null;
        });
    }
}

