/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.database.entries.players;

import com.google.gson.JsonObject;
import io.github.insideranh.stellarprotect.database.entries.LogEntry;
import io.github.insideranh.stellarprotect.enums.ActionType;
import java.sql.ResultSet;
import lombok.Generated;
import org.bukkit.Location;

public class PlayerGameModeLogEntry
extends LogEntry {
    private final byte lastGameMode;
    private final byte newGameMode;

    public PlayerGameModeLogEntry(ResultSet resultSet, JsonObject jsonObject) {
        super(resultSet);
        this.lastGameMode = jsonObject.has("l") ? jsonObject.get("l").getAsByte() : (byte)0;
        this.newGameMode = jsonObject.has("n") ? jsonObject.get("n").getAsByte() : (byte)0;
    }

    public PlayerGameModeLogEntry(long playerId, Location location, int lastGameMode, int newGameMode) {
        super(playerId, ActionType.GAME_MODE.getId(), location, System.currentTimeMillis());
        this.lastGameMode = (byte)lastGameMode;
        this.newGameMode = (byte)newGameMode;
    }

    @Override
    public String getDataString() {
        return this.lastGameMode + ";" + this.newGameMode;
    }

    @Override
    public String toSaveJson() {
        return "{\"l\":" + this.lastGameMode + ",\"n\":" + this.newGameMode + "}";
    }

    @Generated
    public byte getLastGameMode() {
        return this.lastGameMode;
    }

    @Generated
    public byte getNewGameMode() {
        return this.newGameMode;
    }
}

