/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.database.entries.players;

import com.google.gson.JsonObject;
import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.database.entries.LogEntry;
import io.github.insideranh.stellarprotect.enums.ActionType;
import io.github.insideranh.stellarprotect.items.ItemReference;
import io.github.insideranh.stellarprotect.items.ItemTemplate;
import java.sql.ResultSet;
import java.util.Objects;
import lombok.Generated;
import org.bukkit.Location;

public class PlayerItemLogEntry
extends LogEntry {
    private final long itemReferenceId;
    private final int amount;

    public PlayerItemLogEntry(ResultSet resultSet, JsonObject jsonObject) {
        super(resultSet);
        this.itemReferenceId = jsonObject.has("id") ? jsonObject.get("id").getAsLong() : jsonObject.get("it64").getAsLong();
        this.amount = jsonObject.has("a") ? jsonObject.get("a").getAsInt() : 1;
    }

    public PlayerItemLogEntry(long playerId, ItemReference itemReference, Location location, ActionType actionType) {
        super(playerId, actionType.getId(), location, System.currentTimeMillis());
        this.itemReferenceId = itemReference.getTemplateId();
        this.amount = itemReference.getAmount();
    }

    public PlayerItemLogEntry(long playerId, ItemReference itemReference, Location location, ActionType actionType, long currentTime) {
        super(playerId, actionType.getId(), location, currentTime);
        this.itemReferenceId = itemReference.getTemplateId();
        this.amount = itemReference.getAmount();
    }

    @Override
    public String getDataString() {
        ItemTemplate itemTemplate = StellarProtect.getInstance().getItemsManager().getItemTemplate(this.itemReferenceId);
        return itemTemplate.getBukkitItem().getType().name();
    }

    @Override
    public String toSaveJson() {
        return "{\"id\":" + this.itemReferenceId + ",\"a\":" + this.amount + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PlayerItemLogEntry that = (PlayerItemLogEntry)o;
        return this.itemReferenceId == that.itemReferenceId && this.amount == that.amount;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.itemReferenceId, this.amount);
    }

    @Generated
    public long getItemReferenceId() {
        return this.itemReferenceId;
    }

    @Generated
    public int getAmount() {
        return this.amount;
    }
}

