/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.database.entries.players;

import com.google.gson.JsonObject;
import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.blocks.BlockTemplate;
import io.github.insideranh.stellarprotect.database.entries.LogEntry;
import io.github.insideranh.stellarprotect.enums.ActionType;
import io.github.insideranh.stellarprotect.items.ItemReference;
import java.sql.ResultSet;
import lombok.Generated;
import org.bukkit.block.Block;

public class PlayerPlaceRemoveItemLogEntry
extends LogEntry {
    private final int blockId;
    private final long itemReferenceId;
    private final int amount;
    private final byte placed;

    public PlayerPlaceRemoveItemLogEntry(ResultSet resultSet, JsonObject jsonObject) {
        super(resultSet);
        this.blockId = this.getBlockId(jsonObject);
        this.itemReferenceId = jsonObject.has("id") ? jsonObject.get("id").getAsLong() : jsonObject.get("it64").getAsLong();
        this.amount = jsonObject.has("a") ? jsonObject.get("a").getAsInt() : 1;
        this.placed = jsonObject.has("p") ? jsonObject.get("p").getAsByte() : (byte)0;
    }

    public PlayerPlaceRemoveItemLogEntry(long playerId, ItemReference itemReference, Block block, boolean placed, ActionType actionType) {
        super(playerId, actionType.getId(), block.getLocation(), System.currentTimeMillis());
        BlockTemplate itemTemplate = StellarProtect.getInstance().getBlocksManager().getBlockTemplate(block);
        this.blockId = itemTemplate.getId();
        this.itemReferenceId = itemReference.getTemplateId();
        this.amount = itemReference.getAmount();
        this.placed = (byte)(!placed ? 1 : 0);
    }

    public int getBlockId(JsonObject jsonObject) {
        if (jsonObject.has("b")) {
            return jsonObject.get("b").getAsInt();
        }
        if (!jsonObject.has("d")) {
            return -1;
        }
        String data = jsonObject.get("d").getAsString();
        BlockTemplate blockTemplate = StellarProtect.getInstance().getBlocksManager().getBlockTemplate(data);
        return blockTemplate.getId();
    }

    @Override
    public String getDataString() {
        BlockTemplate itemTemplate = StellarProtect.getInstance().getBlocksManager().getBlockTemplate(this.blockId);
        return itemTemplate.getDataBlock().getBlockDataString();
    }

    public boolean isPlaced() {
        return this.placed == 0;
    }

    @Override
    public String toSaveJson() {
        if (this.placed == 0) {
            return "{\"b\":\"" + this.blockId + "\",\"id\":" + this.itemReferenceId + ",\"a\":" + this.amount + "}";
        }
        return "{\"b\":\"" + this.blockId + "\",\"id\":" + this.itemReferenceId + ",\"a\":" + this.amount + ",\"p\":" + this.placed + "}";
    }

    @Generated
    public int getBlockId() {
        return this.blockId;
    }

    @Generated
    public long getItemReferenceId() {
        return this.itemReferenceId;
    }

    @Generated
    public int getAmount() {
        return this.amount;
    }

    @Generated
    public byte getPlaced() {
        return this.placed;
    }
}

